/*  
 *  locus/gdl_locus_type.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_LOCUS_TYPE_H__
#define __GDL_LOCUS_TYPE_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_gentity.h>

__BEGIN_DECLS

typedef struct
{
	gdl_string * name;
} gdl_locus_type;

typedef struct _gdl_locus_type_registry gdl_locus_type_registry;

gdl_locus_type * gdl_locus_type_alloc (const gdl_string * name);
gdl_locus_type * gdl_locus_type_clone (const gdl_locus_type * type);
gdl_locus_type * gdl_locus_type_fread (FILE * stream);
int gdl_locus_type_compare (const gdl_locus_type * t1, const gdl_locus_type * t2);
int gdl_locus_type_fwrite (FILE * stream, const gdl_locus_type* t);
void gdl_locus_type_free (gdl_locus_type * t);

gdl_locus_type_registry * gdl_locus_type_registry_alloc (void);
void gdl_locus_type_registry_free (gdl_locus_type_registry * t);

size_t gdl_locus_type_registry_size (const gdl_locus_type_registry * r);
const gdl_locus_type * gdl_locus_type_registry_get (const gdl_locus_type_registry * r, size_t i);
int gdl_locus_type_registry_add (gdl_locus_type_registry * r, const gdl_locus_type * type, const gdl_locus * locus);
int gdl_locus_type_registry_update (gdl_locus_type_registry * r, const gdl_locus_type * type, const gdl_locus * locus);
const gdl_locus_type * gdl_locus_type_registry_search (const gdl_locus_type_registry * r, const gdl_locus * locus);
int gdl_locus_type_registry_merge (gdl_locus_type_registry * dest, const gdl_locus_type_registry * src);

gdl_locus_type_registry * gdl_locus_type_registry_fread (FILE * stream);
int gdl_locus_type_registry_fwrite (FILE * stream, const gdl_locus_type_registry * r);
gdl_locus_type_registry * gdl_locus_type_registry_fscanf (FILE * stream);
int gdl_locus_type_registry_fprintf (FILE * stream, const gdl_locus_type_registry * r);

typedef struct _gdl_locus_type_registry_itr gdl_locus_type_registry_itr;

gdl_locus_type_registry_itr * gdl_locus_type_registry_iterator (const gdl_locus_type_registry * r, const gdl_locus_type * type);
const gdl_locus * gdl_locus_type_registry_iterator_get (gdl_locus_type_registry_itr * itr);
gdl_boolean gdl_locus_type_registry_iterator_next (gdl_locus_type_registry_itr * itr);
void gdl_locus_type_registry_iterator_free (gdl_locus_type_registry_itr * itr);

GDL_VAR const gdl_locus_type * gdl_locus_dna;
GDL_VAR const gdl_locus_type * gdl_locus_indel;
GDL_VAR const gdl_locus_type * gdl_locus_rflp;
GDL_VAR const gdl_locus_type * gdl_locus_microsat;

__END_DECLS

#endif /* __GDL_LOCUS_TYPE_H__ */
