/*  
 *  mask/gdl_mask.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:47 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_MASK_H__
#define __GDL_MASK_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_clustering.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_odb.h>

__BEGIN_DECLS

typedef struct
{
	gdl_hashtable * table;
} gdl_mask;

typedef gdl_mask * gdl_mask_ptr;

gdl_mask * gdl_mask_alloc ();
gdl_mask * gdl_mask_clone (const gdl_mask * m);
void gdl_mask_free (gdl_mask * m);

gdl_mask * gdl_mask_fread (FILE * stream);
int gdl_mask_fwrite (FILE * stream, const gdl_mask * g);
int gdl_mask_fprintf (FILE * stream, const gdl_mask * g);

int gdl_mask_add (gdl_mask * m, const gdl_entity * e);
int gdl_mask_add_idx (gdl_mask * m, const gdl_entity_type * T, size_t idx);
void gdl_mask_set (gdl_mask * m, const gdl_entity_type * T, gdl_entity_mask * em, size_t owner);
const gdl_entity_mask * gdl_mask_get (const gdl_mask * m, const gdl_entity_type * T);
gdl_entity_mask * gdl_mask_get_clone (const gdl_mask * m, const gdl_entity_type * T);
size_t gdl_mask_get_idx (const gdl_mask * m, const gdl_entity_type * T, size_t i);
void gdl_mask_remove (const gdl_mask * m, const gdl_entity_type * T, size_t i);
size_t gdl_mask_size (const gdl_mask * m, const gdl_entity_type * T);
void gdl_mask_reset (gdl_mask * m, const gdl_entity_type * T);
void gdl_mask_set_identity (gdl_mask * m, const gdl_entity_type * T, size_t n);

gdl_mask * gdl_mask_clustering (const gdl_mask * m, const gdl_entity_type * T, const gdl_clustering * clustering);
gdl_mask * gdl_mask_ligation (const gdl_mask * m1, const gdl_mask * m2, const gdl_entity_type * ENTITY_LIGATION, const gdl_entity_type * ENTITY_OVER, gdl_entity_mask ** ma1, gdl_entity_mask ** ma2);

void gdl_mask_reverse (gdl_mask * m, const gdl_entity_type * T, const void * data, gdl_entity * (*get)(const void * data, size_t i), size_t (*size)(const void * data));

GDL_VAR const gdl_odriver * gdl_mask_driver;

__END_DECLS

#endif
