/*  
 *  mask/odriver.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:47 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#include <gdl/gdl_common.h>
#include <gdl/gdl_meta.h>
#include <gdl/gdl_odb.h>
#include <gdl/gdl_mask.h>

static gdl_meta *
_gdl_mask_meta (const void * obj)
{
	gdl_meta_tag * tag;
	gdl_meta * meta = gdl_meta_alloc ();
	gdl_mask * mask = (gdl_mask *) obj;
	
	if (gdl_mask_size (mask, GDL_ACCESSION))
	{
		tag = gdl_meta_tag_alloc ();
		gdl_meta_tag_name (tag, "Accession");
		gdl_meta_tag_value (tag, "%d", gdl_mask_size (mask, GDL_ACCESSION));
		gdl_meta_add (meta, tag);
	}
	if (gdl_mask_size (mask, GDL_LOCUS))
	{
		tag = gdl_meta_tag_alloc ();
		gdl_meta_tag_name (tag, "Locus");
		gdl_meta_tag_value (tag, "%e", gdl_mask_size (mask, GDL_LOCUS));
		gdl_meta_add (meta, tag);
	}
	if (gdl_mask_size (mask, GDL_FACTOR))
	{
		tag = gdl_meta_tag_alloc ();
		gdl_meta_tag_name (tag, "Factor");
		gdl_meta_tag_value (tag, "%e", gdl_mask_size (mask, GDL_FACTOR));
		gdl_meta_add (meta, tag);
	}
	
	return meta;
}

static void *
_gdl_mask_fread (FILE * stream)
{
	return gdl_mask_fread (stream);
}

static int
_gdl_mask_fwrite (FILE * stream, const void * obj)
{
	const gdl_mask * mask = (gdl_mask *) obj;
	return gdl_mask_fwrite (stream, mask);
}

static int
_gdl_mask_fprintf (FILE * stream, const void * obj)
{
	const gdl_mask * mask = (gdl_mask *) obj;
	return gdl_mask_fprintf (stream, mask);
}

static const gdl_odriver _gdl_mask_driver =
{
    "gdl_mask",
    "1.0",
    &_gdl_mask_meta,
    &_gdl_mask_fread,
    &_gdl_mask_fwrite,
    &_gdl_mask_fprintf
};

const gdl_odriver * gdl_mask_driver = &_gdl_mask_driver;
