/* matrix/test_source.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

void FUNCTION (test, func) (void);
void FUNCTION (test, trap) (void);
void FUNCTION (test, text) (void);
void FUNCTION (test, binary) (void);


void
FUNCTION (test, func) (void)
{
  TYPE (gdl_vector) * v;
  size_t i, j;
  size_t k = 0;

  TYPE (gdl_matrix) * m = FUNCTION (gdl_matrix, alloc) (M, N);

  gdl_test (m->data == 0, NAME (gdl_matrix) "_alloc returns valid pointer");
  gdl_test (m->size1 != M, NAME (gdl_matrix) "_alloc returns valid size1");
  gdl_test (m->size2 != N, NAME (gdl_matrix) "_alloc returns valid size2");
  gdl_test (m->tda != N, NAME (gdl_matrix) "_alloc returns valid tda");

  for (i = 0; i < M; i++)
    {
      for (j = 0; j < N; j++)
        {
          k++;
          FUNCTION (gdl_matrix, set) (m, i, j, (BASE) k);
        }
    }

  {
    status = 0;
    k = 0;
    for (i = 0; i < M; i++)
      {
        for (j = 0; j < N; j++)
          {
            k++;
            if (m->data[i * N + j] != (BASE) k)
              status = 1;
          };
      };

    gdl_test (status, NAME (gdl_matrix) "_set writes into array");
  }

  {
    status = 0;
    k = 0;
    for (i = 0; i < M; i++)
      {
        for (j = 0; j < N; j++)
          {
            k++;
            if (FUNCTION (gdl_matrix, get) (m, i, j) != (BASE) k)
              status = 1;
          };
      };
    gdl_test (status, NAME (gdl_matrix) "_get reads from array");
  }


  FUNCTION (gdl_matrix, free) (m);      /* free whatever is in m */

  m = FUNCTION (gdl_matrix, calloc) (M, N);
  v = FUNCTION (gdl_vector, calloc) (N);

  k = 0;
  for (i = 0; i < M; i++)
    {
      for (j = 0; j < N; j++)
        {
          k++;
          FUNCTION (gdl_matrix, set) (m, i, j, (BASE) k);
        }
    }

//  {
//    status = 0;
//    k = 0;
//    for (i = 0; i < M; i++)
//      {
//        FUNCTION (gdl_matrix, get_row) (v, m, i);
//
//        for (j = 0; j < N; j++)
//          {
//            k++;
//            if (v->data[j] != (BASE) k)
//              status = 1;
//          }
//      }
//
//    gdl_test (status, NAME (gdl_matrix) "_get_row extracts row");
//  }

  {
    BASE exp_max = FUNCTION(gdl_matrix, get) (m, 0, 0);
    BASE exp_min = FUNCTION(gdl_matrix, get) (m, 0, 0);
    size_t exp_imax = 0, exp_jmax = 0, exp_imin = 0, exp_jmin = 0;

    for (i = 0; i < M; i++)
      {
        for (j = 0; j < N; j++)
          {
            BASE k = FUNCTION(gdl_matrix, get) (m, i, j);
            if (k > exp_max) {
              exp_max =  FUNCTION(gdl_matrix, get) (m, i, j);
              exp_imax = i;
              exp_jmax = j;
            }
            if (k < exp_min) {
              exp_min =  FUNCTION(gdl_matrix, get) (m, i, j);
              exp_imin = i;
              exp_jmin = j;
            }
          }
      }

    {
      BASE max = FUNCTION(gdl_matrix, max) (m) ;

      gdl_test (max != exp_max, NAME(gdl_matrix) "_max returns correct maximum value");
    }

    {
      BASE min = FUNCTION(gdl_matrix, min) (m) ;
      
      gdl_test (min != exp_min, NAME(gdl_matrix) "_min returns correct minimum value");
    }

    {
      BASE min, max;
      FUNCTION(gdl_matrix, minmax) (m, &min, &max);

      gdl_test (max != exp_max, NAME(gdl_matrix) "_minmax returns correct maximum value");
      gdl_test (min != exp_min, NAME(gdl_matrix) "_minmax returns correct minimum value");
    }


    {
      size_t imax, jmax;
      FUNCTION(gdl_matrix, max_index) (m, &imax, &jmax) ;

      gdl_test (imax != exp_imax, NAME(gdl_matrix) "_max_index returns correct maximum i");
      gdl_test (jmax != exp_jmax, NAME(gdl_matrix) "_max_index returns correct maximum j");
    }

    {
      size_t imin, jmin;
      FUNCTION(gdl_matrix, min_index) (m, &imin, &jmin) ;

      gdl_test (imin != exp_imin, NAME(gdl_matrix) "_min_index returns correct minimum i");
      gdl_test (jmin != exp_jmin, NAME(gdl_matrix) "_min_index returns correct minimum j");
    }

    {
      size_t imin, jmin, imax, jmax;

      FUNCTION(gdl_matrix, minmax_index) (m,  &imin, &jmin, &imax, &jmax);

      gdl_test (imax != exp_imax, NAME(gdl_matrix) "_minmax_index returns correct maximum i");
      gdl_test (jmax != exp_jmax, NAME(gdl_matrix) "_minmax_index returns correct maximum j");

      gdl_test (imin != exp_imin, NAME(gdl_matrix) "_minmax_index returns correct minimum i");
      gdl_test (jmin != exp_jmin, NAME(gdl_matrix) "_minmax_index returns correct minimum j");
    }
  }

  {
    TYPE (gdl_matrix) * a = FUNCTION (gdl_matrix, calloc) (M, N);
    TYPE (gdl_matrix) * b = FUNCTION (gdl_matrix, calloc) (M, N);
    
    for (i = 0; i < M; i++)
      {
        for (j = 0; j < N; j++)
          {
            FUNCTION (gdl_matrix, set) (a, i, j, (BASE)(3 + i +  5 * j));
            FUNCTION (gdl_matrix, set) (b, i, j, (BASE)(3 + 2 * i + 4 * j));
          }
      }
    
    FUNCTION(gdl_matrix, memcpy) (m, a);
    FUNCTION(gdl_matrix, add) (m, b);
    
    {
      int status = 0;
      
      for (i = 0; i < M; i++)
        {
          for (j = 0; j < N; j++)
            {
              BASE r = FUNCTION(gdl_matrix,get) (m,i,j);
              BASE x = FUNCTION(gdl_matrix,get) (a,i,j);
              BASE y = FUNCTION(gdl_matrix,get) (b,i,j);
              BASE z = x + y;
              if (r != z)
                status = 1;
            }
        }
      gdl_test (status, NAME (gdl_matrix) "_add matrix addition");
    }


    FUNCTION(gdl_matrix, memcpy) (m, a);
    FUNCTION(gdl_matrix, sub) (m, b);
    
    {
      int status = 0;
      
      for (i = 0; i < M; i++)
        {
          for (j = 0; j < N; j++)
            {
              BASE r = FUNCTION(gdl_matrix,get) (m,i,j);
              BASE x = FUNCTION(gdl_matrix,get) (a,i,j);
              BASE y = FUNCTION(gdl_matrix,get) (b,i,j);
              BASE z = x - y;
              if (r != z)
                status = 1;
            }
        }
      gdl_test (status, NAME (gdl_matrix) "_sub matrix subtraction");
    }

    FUNCTION(gdl_matrix, memcpy) (m, a);
    FUNCTION(gdl_matrix, mul_elements) (m, b);
    
    {
      int status = 0;
      
      for (i = 0; i < M; i++)
        {
          for (j = 0; j < N; j++)
            {
              BASE r = FUNCTION(gdl_matrix,get) (m,i,j);
              BASE x = FUNCTION(gdl_matrix,get) (a,i,j);
              BASE y = FUNCTION(gdl_matrix,get) (b,i,j);
              BASE z = x * y;
              if (r != z)
                status = 1;
            }
        }
      gdl_test (status, NAME (gdl_matrix) "_mul_elements multiplication");
    }

    FUNCTION(gdl_matrix, memcpy) (m, a);
    FUNCTION(gdl_matrix, div_elements) (m, b);
    
    {
      int status = 0;
      
      for (i = 0; i < M; i++)
        {
          for (j = 0; j < N; j++)
            {
              BASE r = FUNCTION(gdl_matrix,get) (m,i,j);
              BASE x = FUNCTION(gdl_matrix,get) (a,i,j);
              BASE y = FUNCTION(gdl_matrix,get) (b,i,j);
              BASE z = x / y;
              if (fabs(r - z) > 2 * GDL_FLT_EPSILON * fabs(z))
                status = 1;
            }
        }
      gdl_test (status, NAME (gdl_matrix) "_div_elements division");
    }


    FUNCTION(gdl_matrix, free) (a);
    FUNCTION(gdl_matrix, free) (b);
  }


 FUNCTION (gdl_matrix, free) (m);
 FUNCTION (gdl_vector, free) (v);
}

#if !(USES_LONGDOUBLE && !HAVE_PRINTF_LONGDOUBLE)
void
FUNCTION (test, text) (void)
{
  TYPE (gdl_matrix) * m = FUNCTION (gdl_matrix, alloc) (M, N);

  size_t i, j;
  int k = 0;

  {
    FILE *f = fopen ("test.txt", "w");

    for (i = 0; i < M; i++)
      {
        for (j = 0; j < N; j++)
          {
            k++;
            FUNCTION (gdl_matrix, set) (m, i, j, (BASE) k);
          }
      }

    FUNCTION (gdl_matrix, fprintf) (f, m, OUT_FORMAT);
    fclose (f);
  }

  {
    FILE *f = fopen ("test.txt", "r");
    TYPE (gdl_matrix) * mm = FUNCTION (gdl_matrix, alloc) (M, N);
    status = 0;

    FUNCTION (gdl_matrix, fscanf) (f, mm);
    k = 0;
    for (i = 0; i < M; i++)
      {
        for (j = 0; j < N; j++)
          {
            k++;
            if (mm->data[i * N + j] != (BASE) k)
              status = 1;
          }
      }

    gdl_test (status, NAME (gdl_matrix) "_fprintf and fscanf");

    fclose (f);
    FUNCTION (gdl_matrix, free) (mm);
  }

  FUNCTION (gdl_matrix, free) (m);
}
#endif

void
FUNCTION (test, binary) (void)
{
  TYPE (gdl_matrix) * m = FUNCTION (gdl_matrix, calloc) (M, N);

  size_t i, j;
  size_t k = 0;

  {
    FILE *f = fopen ("test.dat", "wb");
    k = 0;
    for (i = 0; i < M; i++)
      {
        for (j = 0; j < N; j++)
          {
            k++;
            FUNCTION (gdl_matrix, set) (m, i, j, (BASE) k);
          }
      }

    FUNCTION (gdl_matrix, fwrite) (f, m);
    fclose (f);
  }

  {
    FILE *f = fopen ("test.dat", "rb");
    TYPE (gdl_matrix) * mm = FUNCTION (gdl_matrix, alloc) (M, N);
    status = 0;

    mm = FUNCTION (gdl_matrix, fread) (f);
    k = 0;
    for (i = 0; i < M; i++)
      {
        for (j = 0; j < N; j++)
          {
            k++;
            if (mm->data[i * N + j] != (BASE) k)
              status = 1;
          }
      }

    gdl_test (status, NAME (gdl_matrix) "_write and read");

    fclose (f);
    FUNCTION (gdl_matrix, free) (mm);
  }

  FUNCTION (gdl_matrix, free) (m);
}

void
FUNCTION (test, trap) (void)
{
  TYPE (gdl_matrix) * m = FUNCTION (gdl_matrix, alloc) (M, N);

  size_t i = 0, j = 0;
  double x;

  status = 0;
  FUNCTION (gdl_matrix, set) (m, M + 1, 0, (BASE) 1.2);
  gdl_test (!status,
            NAME (gdl_matrix) "_set traps 1st index above upper bound");

  status = 0;
  FUNCTION (gdl_matrix, set) (m, 0, N + 1, (BASE) 1.2);
  gdl_test (!status,
            NAME (gdl_matrix) "_set traps 2nd index above upper bound");

  status = 0;
  FUNCTION (gdl_matrix, set) (m, M, 0, (BASE) 1.2);
  gdl_test (!status,
            NAME (gdl_matrix) "_set traps 1st index at upper bound");

  status = 0;
  FUNCTION (gdl_matrix, set) (m, 0, N, (BASE) 1.2);
  gdl_test (!status,
            NAME (gdl_matrix) "_set traps 2nd index at upper bound");

  status = 0;
  x = FUNCTION (gdl_matrix, get) (m, i - 1, 0);
  gdl_test (!status,
            NAME (gdl_matrix) "_get traps 1st index below lower bound");
  gdl_test (x != 0,
     NAME (gdl_matrix) "_get returns zero for 1st index below lower bound");

  status = 0;
  x = FUNCTION (gdl_matrix, get) (m, 0, j - 1);
  gdl_test (!status,
            NAME (gdl_matrix) "_get traps 2nd index below lower bound");
  gdl_test (x != 0,
     NAME (gdl_matrix) "_get returns zero for 2nd index below lower bound");

  status = 0;
  x = FUNCTION (gdl_matrix, get) (m, M + 1, 0);
  gdl_test (!status,
            NAME (gdl_matrix) "_get traps 1st index above upper bound");
  gdl_test (x != 0,
     NAME (gdl_matrix) "_get returns zero for 1st index above upper bound");

  status = 0;
  x = FUNCTION (gdl_matrix, get) (m, 0, N + 1);
  gdl_test (!status,
            NAME (gdl_matrix) "_get traps 2nd index above upper bound");
  gdl_test (x != 0,
     NAME (gdl_matrix) "_get returns zero for 2nd index above upper bound");

  status = 0;
  x = FUNCTION (gdl_matrix, get) (m, M, 0);
  gdl_test (!status,
            NAME (gdl_matrix) "_get traps 1st index at upper bound");
  gdl_test (x != 0,
        NAME (gdl_matrix) "_get returns zero for 1st index at upper bound");

  status = 0;
  x = FUNCTION (gdl_matrix, get) (m, 0, N);
  gdl_test (!status,
            NAME (gdl_matrix) "_get traps 2nd index at upper bound");
  gdl_test (x != 0,
        NAME (gdl_matrix) "_get returns zero for 2nd index at upper bound");

  FUNCTION (gdl_matrix, free) (m);
}
