/*  
 *  meta/gdl_meta.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_META_H__

#define __GDL_META_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_string.h>

__BEGIN_DECLS

typedef struct _gdl_meta gdl_meta;

typedef struct {
	gdl_string * name;
	gdl_string * value;
} gdl_meta_tag;

gdl_meta_tag * gdl_meta_tag_alloc (void);
void gdl_meta_tag_free (gdl_meta_tag * tag);
void gdl_meta_tag_name (gdl_meta_tag * tag, const char * format, ...);
void gdl_meta_tag_value (gdl_meta_tag * tag, const char * format, ...);
gdl_meta_tag * gdl_meta_tag_fread (FILE * stream);
int gdl_meta_tag_fwrite (FILE * stream, const gdl_meta_tag * tag);

gdl_meta * gdl_meta_alloc (void);
void gdl_meta_free (gdl_meta * m);
void gdl_meta_add (gdl_meta * m, gdl_meta_tag * tag);


gdl_meta * gdl_meta_fread (FILE * stream);
int gdl_meta_fwrite (FILE * stream, const gdl_meta * m);
gdl_meta * gdl_meta_fscanf (FILE * stream);
int gdl_meta_name_fprintf (FILE * stream, gdl_meta * m);
int gdl_meta_value_fprintf (FILE * stream, gdl_meta * m);
int gdl_meta_fprintf (FILE * stream, gdl_meta * m);

__END_DECLS

#endif /* __GDL_META_H__ */
