/*  
 * 	meta/meta.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_meta.h>

struct _gdl_meta
{
	gdl_list * tags;
};

static void
meta_tag_list_free (void * data)
{
	gdl_meta_tag * t = (gdl_meta_tag *) data;
	gdl_meta_tag_free (t);
}

static gdl_data_interface _meta_tag_type =
{
	&meta_tag_list_free,
	NULL,
	NULL,
	NULL,
	NULL
};


gdl_meta_tag *
gdl_meta_tag_alloc (void)
{
	gdl_meta_tag * m;
	
	m = GDL_MALLOC (gdl_meta_tag, 1);
	
	if (m == 0)
	{
		GDL_ERROR_VAL ("Failed to allocate memory for gdl_meta_tag",
                        GDL_ENOMEM, 0);
	}
	
	m->name  = NULL;
	m->value = NULL;
	
	return m;
}

void
gdl_meta_tag_free (gdl_meta_tag * t)
{
   if (t == 0)
      return;
   GDL_FREE (t->name);
   GDL_FREE (t->value);
   GDL_FREE (t);
}

void
gdl_meta_tag_name (gdl_meta_tag * tag, const char * format, ...)
{
	if (tag == 0 || format == 0)
	{
		return;	
	}
	else
	{
		va_list ap;
		va_start (ap, format);
		tag->name = gdl_string_vsprintf (format, ap);
    }
}

void
gdl_meta_tag_value (gdl_meta_tag * tag, const char * format, ...)
{
	if (tag == 0 || format == 0)
	{
		return;	
	}
	else
	{
		va_list ap;
		va_start (ap, format);
		tag->value = gdl_string_vsprintf (format, ap);
	}
}

gdl_meta *
gdl_meta_alloc (void)
{
	gdl_meta * m;
	
	m = GDL_MALLOC (gdl_meta, 1);
	
	if (m == 0)
	{
		GDL_ERROR_VAL ("Failed to allocate memory for gdl_meta",
                        GDL_ENOMEM, 0);
	}
	
	m->tags = gdl_list_alloc (&_meta_tag_type);
	
	return m;
}

void
gdl_meta_free (gdl_meta * m)
{
	if (m == 0)
		return;
	gdl_list_free (m->tags);
	GDL_FREE (m);	
}

void
gdl_meta_add (gdl_meta * m, gdl_meta_tag * tag)
{
	if (m == 0 || tag == 0)
		return;
	gdl_list_push_back (m->tags, tag, 1);	
}

#include "factory.c"
