/*  
 *  mosaic/odriver.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:01 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_odb.h>
#include <gdl/gdl_mosaic_result.h>

static gdl_meta *
_gdl_mosaic_result_meta (const void * obj)
{
	gdl_meta_tag * tag;
	gdl_meta * meta;
	gdl_mosaic_result * r;
	
	r = (gdl_mosaic_result *) obj;
	
	meta = gdl_meta_alloc ();
	
	tag = gdl_meta_tag_alloc ();
	gdl_meta_tag_name (tag, "K");
	gdl_meta_tag_value (tag, "%d", r->K);
	gdl_meta_add (meta, tag);
	tag = gdl_meta_tag_alloc ();
	gdl_meta_tag_name (tag, "Ln(Proba)");
	gdl_meta_tag_value (tag, "%.1f", r->log);
	gdl_meta_add (meta, tag);
	tag = gdl_meta_tag_alloc ();
//	gdl_meta_tag_name (tag, gdl_mosaic_criterion_BIC->acronym);
//	gdl_meta_tag_value (tag, "%.1f", gdl_mosaic_result_criterion (r, gdl_mosaic_criterion_BIC));
//	gdl_meta_add (meta, tag);
//	tag = gdl_meta_tag_alloc ();
//	gdl_meta_tag_name (tag, gdl_mosaic_criterion_AIC->acronym);
//	gdl_meta_tag_value (tag, "%.1f", gdl_mosaic_result_criterion (r, gdl_mosaic_criterion_AIC));
//	gdl_meta_add (meta, tag);
	
	return meta;
}

static void *
_gdl_mosaic_result_fread (FILE * stream)
{
	return gdl_mosaic_result_fread (stream);
}

static int
_gdl_mosaic_result_fwrite (FILE * stream, const void * obj)
{
	const gdl_mosaic_result * result = (gdl_mosaic_result *) obj;
	return gdl_mosaic_result_fwrite (stream, result);
}

static int
_gdl_mosaic_result_fprintf (FILE * stream, const void * obj)
{
	const gdl_mosaic_result * result = (gdl_mosaic_result *) obj;
	return gdl_mosaic_result_fprintf (stream, result);
}

static const gdl_odriver _gdl_mosaic_result_driver =
{
    "gdl_mosaic_result",
    "1.0",
    &_gdl_mosaic_result_meta,
    &_gdl_mosaic_result_fread,
    &_gdl_mosaic_result_fwrite,
    &_gdl_mosaic_result_fprintf
};

const gdl_odriver * gdl_mosaic_result_driver = &_gdl_mosaic_result_driver;
