/* multifit/gdl_multifit.h
 * 
 * Copyright (C) 2000 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GDL_MULTIFIT_H__
#define __GDL_MULTIFIT_H__

#include <stdlib.h>
#include <gdl/gdl_common.h>
#include <gdl/gdl_math.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_matrix.h>


__BEGIN_DECLS

typedef struct 
{
  size_t n; /* number of observations */
  size_t p; /* number of parameters */
  gdl_matrix * A;
  gdl_matrix * Q;
  gdl_matrix * QSI;
  gdl_vector * S;
  gdl_vector * t;
  gdl_vector * xt;
  gdl_vector * D;
} 
gdl_multifit_linear_workspace;

gdl_multifit_linear_workspace *
gdl_multifit_linear_alloc (size_t n, size_t p);

void
gdl_multifit_linear_free (gdl_multifit_linear_workspace * work);

int
gdl_multifit_linear (const gdl_matrix * X,
                     const gdl_vector * y,
                     gdl_vector * c,
                     gdl_matrix * cov,
                     double * chisq,
                     gdl_multifit_linear_workspace * work);

int
gdl_multifit_linear_svd (const gdl_matrix * X,
                         const gdl_vector * y,
                         double tol,
                         size_t * rank,
                         gdl_vector * c,
                         gdl_matrix * cov,
                         double *chisq, 
                         gdl_multifit_linear_workspace * work);

int
gdl_multifit_wlinear (const gdl_matrix * X,
                      const gdl_vector * w,
                      const gdl_vector * y,
                      gdl_vector * c,
                      gdl_matrix * cov,
                      double * chisq,
                      gdl_multifit_linear_workspace * work);

int
gdl_multifit_wlinear_svd (const gdl_matrix * X,
                          const gdl_vector * w,
                          const gdl_vector * y,
                          double tol,
                          size_t * rank,
                          gdl_vector * c,
                          gdl_matrix * cov,
                          double *chisq, 
                          gdl_multifit_linear_workspace * work);

int
gdl_multifit_linear_est (const gdl_vector * x,
                         const gdl_vector * c,
                         const gdl_matrix * cov, double *y, double *y_err);


__END_DECLS

#endif /* __GDL_MULTIFIT_H__ */
