/* multireg/gdl_multireg.h
 * 
 * Copyright (C) 2006 Jean-Baptiste Veyrieras
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GDL_MULTIREG_H__
#define __GDL_MULTIREG_H__

#include <stdlib.h>
#include <gdl/gdl_common.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_math.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_multifit.h>

__BEGIN_DECLS

typedef struct _gdl_multireg_linear_workspace gdl_multireg_linear_workspace;

gdl_multireg_linear_workspace * gdl_multireg_linear_workspace_alloc (size_t n, size_t p);
void gdl_multireg_linear_workspace_free (gdl_multireg_linear_workspace * w);

size_t gdl_multireg_linear_workspace_size1 (const gdl_multireg_linear_workspace * w);
size_t gdl_multireg_linear_workspace_size2 (const gdl_multireg_linear_workspace * w);

int gdl_multireg_linear_perform (gdl_multireg_linear_workspace * w, const gdl_matrix * X, const gdl_vector * y);
int gdl_multireg_linear_eval (gdl_multireg_linear_workspace * w, const gdl_matrix * X0, const gdl_matrix * X1, const gdl_vector * y);
int gdl_multireg_linear_eval_permut (gdl_multireg_linear_workspace * w, const gdl_matrix * X0, const gdl_matrix * X1, const gdl_vector * y, const size_t boot, const gdl_rng * rng);

const gdl_vector * gdl_multireg_linear_coefficients (const gdl_multireg_linear_workspace * w);
const gdl_matrix * gdl_multireg_linear_covariance (const gdl_multireg_linear_workspace * w);
double gdl_multireg_linear_rss (const gdl_multireg_linear_workspace * w);
double gdl_multireg_linear_tss (const gdl_multireg_linear_workspace * w);
double gdl_multireg_linear_rsquare (const gdl_multireg_linear_workspace * w);
size_t gdl_multireg_linear_df (const gdl_multireg_linear_workspace * w);

double gdl_multireg_linear_eval_rsquare (const gdl_multireg_linear_workspace * w);
double gdl_multireg_linear_eval_rss0 (const gdl_multireg_linear_workspace * w);
double gdl_multireg_linear_eval_rss1 (const gdl_multireg_linear_workspace * w);
size_t gdl_multireg_linear_eval_df (const gdl_multireg_linear_workspace * w);
double gdl_multireg_linear_eval_fstat (const gdl_multireg_linear_workspace * w);
double gdl_multireg_linear_eval_pvalue (const gdl_multireg_linear_workspace * w);

double gdl_univreg_perform (const double y[], const double x[], const size_t n, double * mu, double * r2, double * p);

__END_DECLS

#endif
