/*  
 *  odb/gdl_odb.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_ODB_H__

#define __GDL_ODB_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_meta.h>

__BEGIN_DECLS

typedef struct _gdl_odb gdl_odb;

typedef struct _gdl_oheader gdl_oheader;

typedef struct
{
    const char * name;
    const char * version;
    gdl_meta  * (*meta) (const void * obj);
    void * (*fread) (FILE * stream);
    int    (*fwrite) (FILE * stream, const void * obj);
    int    (*fprintf) (FILE * stream, const void * obj);
} gdl_odriver;

gdl_odb * gdl_odb_alloc (const char * filename);
void gdl_odb_free (gdl_odb * r);
int gdl_odb_insert (gdl_odb * r, const gdl_odriver * driver, const void * obj);
void * gdl_odb_search (gdl_odb * r, const gdl_odriver * driver, size_t id);
int gdl_odb_fsummary (gdl_odb * r, FILE * stream, int gout);
size_t gdl_odb_size (gdl_odb * r);

// TODO void * gdl_odb_fremove (gdl_odb * r, size_t id);
// TODO int gdl_odb_fswap (gdl_odb * r, size_t id1, size_t id2);

typedef struct _gdl_odriver_registry gdl_odriver_registry;

gdl_odriver_registry * gdl_odriver_registry_get ();

const gdl_odriver * gdl_odriver_registry_get_driver (gdl_odriver_registry * r, const gdl_string * name);
int gdl_odriver_registry_add_driver (gdl_odriver_registry * r, const gdl_odriver * driver);

GDL_VAR gdl_odriver_registry * gdl_odriver_registry_singleton;

__END_DECLS

#endif //__GDL_ODB_H__

