/*  
 * 	odb/insert.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_odb.h>

static gdl_oheader *
odb_create_oheader (gdl_odb * r,
                               const gdl_odriver * driver,
                               const void * object)
{
	int status;
	gdl_oheader * header;
	
	header = gdl_oheader_alloc ();
	
	header->id   = r->size;
	
	header->date = gdl_time2ascii ();
	
	header->driver_name    = gdl_string_clone (driver->name);
	
	header->driver_version = gdl_string_clone (driver->version);
	
	header->meta = driver->meta (object);
	
	return header;
}

int
odb_insert (gdl_odb * r,
                               const gdl_odriver * driver,
                               const void * object)
{
	int status;
	FILE * stream = r->_stream;
	
	gdl_oheader * header = odb_create_oheader (r, driver, object);
	
	fprintf (stream, GDL_ODB_TAG);
	
	fprintf (stream, "\n");
	
	status = oheader_fprintf (stream, header, 0);
	
	fprintf (stream, "\n");
	
	status = (driver->fwrite)(stream, object);
	
	fprintf (stream, "\n");
	
	gdl_oheader_free (header);
	
	return status;
}
                               
int
gdl_odb_insert (gdl_odb * r,
                               const gdl_odriver * driver,
                               const void * object)
{
	if (r == 0 || driver == 0 || object == 0)
	{
		return (-1);	
	}
	else
	{
		// get header on the handler
		odb_ropen (r, 0);
		odb_close (r);
		// increment the size of the handler
		r->size++;
		// open it
		odb_uopen (r);
		// go to the last result
		odb_rjump (r, r->size);
		// add the result
		if (odb_insert (r, driver, object) != GDL_SUCCESS)
		{
			odb_close (r);
			r->size--;
			odb_uopen (r);
			odb_close (r);
			return (-1);	
		}
		// close it
		odb_close (r);
		
		return (r->size);
	}
}
