/*  
 * 	odb/search.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_odb.h>

static void * 
odb_load_result (gdl_odb * r, const gdl_odriver * driver)
{
	gdl_oheader * header = oheader_fscanf (r->_stream);
	
	if (strcmp (header->driver_name, driver->name))
	{
		return NULL;
	}
	else if (strcmp (header->driver_version, driver->version))
	{
		return NULL;
	}
	else
	{
		return driver->fread (r->_stream);
	}
}
                              
void *
gdl_odb_search (gdl_odb * r, 
                 const gdl_odriver * driver,
                 const size_t id)
{
	if (r == 0)
	{
		return NULL;
	}
	else
	{
		void * result;
		
		// get header on the handler
		odb_ropen (r, 0);
		if (id > r->size)
		{
			return NULL;
		}
		// go to the result
		odb_rjump (r, id);
		result = odb_load_result (r, driver);
		// close 
		odb_close (r);
		
		return result;
	}
}
