/* permutation/init.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <stdlib.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_permutation.h>

gdl_permutation *
gdl_permutation_alloc (const size_t n)
{
  gdl_permutation * p;

  if (n == 0)
    {
      GDL_ERROR_VAL ("permutation length n must be positive integer",
                        GDL_EDOM, 0);
    }

  p = (gdl_permutation *) malloc (sizeof (gdl_permutation));

  if (p == 0)
    {
      GDL_ERROR_VAL ("failed to allocate space for permutation struct",
                        GDL_ENOMEM, 0);
    }

  p->data = (size_t *) malloc (n * sizeof (size_t));

  if (p->data == 0)
    {
      free (p);         /* exception in constructor, avoid memory leak */

      GDL_ERROR_VAL ("failed to allocate space for permutation data",
                        GDL_ENOMEM, 0);
    }

  p->size = n;

  return p;
}

gdl_permutation *
gdl_permutation_calloc (const size_t n)
{
  size_t i;

  gdl_permutation * p =  gdl_permutation_alloc (n);

  if (p == 0)
    return 0;

  /* initialize permutation to identity */

  for (i = 0; i < n; i++)
    {
      p->data[i] = i;
    }

  return p;
}

void
gdl_permutation_init (gdl_permutation * p)
{
  const size_t n = p->size ;
  size_t i;

  /* initialize permutation to identity */

  for (i = 0; i < n; i++)
    {
      p->data[i] = i;
    }
}

void
gdl_permutation_free (gdl_permutation * p)
{
  free (p->data);
  free (p);
}
