/*  
 * 	phase/em_pl.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_view.h>
#include <gdl/gdl_phase_em_pl.h>

gdl_phase_em_pl_param *
gdl_phase_em_pl_param_alloc (const gdl_view * v,
                              const gdl_mask * m,
                              const gdl_rng * rng,
                              double pmt,
                              double phcrm,
                              size_t psize,
                              size_t kbest)
{
	gdl_phase_em_pl_param * P;
	
	P = GDL_MALLOC (gdl_phase_em_pl_param, 1);
	
	P->v = v;
	P->m = m;
	P->r = rng;
	P->pmt = pmt;
	P->phcrm = phcrm;
	P->psize = psize;
	P->kbest = kbest;
	
	return P;
}

void
gdl_phase_em_pl_param_free (gdl_phase_em_pl_param * P)
{
	GDL_FREE (P);
}

gdl_phase_em_pl_workspace *
gdl_phase_em_pl_workspace_alloc (const gdl_phase_em_pl_workspace_type * T,
                                    gdl_phase_em_pl_param * P)
{
	gdl_phase_em_pl_workspace * w;
	
	w = GDL_MALLOC (gdl_phase_em_pl_workspace, 1);
	
	w->type = T;
	
	w->param = P;
	
	w->state = gdl_malloc (w->type->size);
	
	(w->type->alloc)(w->state, P);
	
	return w;
}

void
gdl_phase_em_pl_workspace_free (gdl_phase_em_pl_workspace * w)
{
	if (w)
	{
		(w->type->free)(w->state);
		GDL_FREE (w->state);
		gdl_phase_em_pl_param_free (w->param);
		GDL_FREE (w);
	}	
}

int
gdl_phase_em_pl_workspace_init (gdl_phase_em_pl_workspace * w, const gdl_gligation_type * T)
{
	return (w->type->init)(w->state, T);
}

size_t
gdl_phase_em_pl_workspace_psize (gdl_phase_em_pl_workspace * w)
{
	return (w->type->psize)(w->state);
}

int
gdl_phase_em_pl_workspace_iterate (gdl_phase_em_pl_workspace * w, size_t i)
{
	return (w->type->iterate)(w->state, i);
}

int
gdl_phase_em_pl_workspace_ligation (gdl_phase_em_pl_workspace * w)
{
	return (w->type->ligation)(w->state);
}

double
gdl_phase_em_pl_workspace_loglikelihood (const gdl_phase_em_pl_workspace * w)
{
	return (w->type->loglikelihood)(w->state);
}

double
gdl_phase_em_pl_workspace_residual_abs (const gdl_phase_em_pl_workspace * w)
{
	return (w->type->residual_abs)(w->state);
}

double
gdl_phase_em_pl_workspace_residual_sq (const gdl_phase_em_pl_workspace * w)
{
	return (w->type->residual_sq)(w->state);
}

void *
gdl_phase_em_pl_workspace_result (const gdl_phase_em_pl_workspace * w)
{
	return (w->type->result)(w->state);	
}

int
gdl_phase_em_pl_workspace_fread (FILE * stream, gdl_phase_em_pl_workspace * w)
{
		
}

int
gdl_phase_em_pl_workspace_fwrite (FILE * stream, const gdl_phase_em_pl_workspace * w)
{
	
}
