/*  
 * 	phase/gdl_phase_em_pl.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#ifndef __GDL_PHASE_EM_PL_H__
#define __GDL_PHASE_EM_PL_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_gpartition.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_view.h>
 
 __BEGIN_DECLS

typedef struct
{
	const gdl_view * v;
	const gdl_mask * m;
	const gdl_rng * r;
	double pmt;
	double phcrm;
	size_t psize;
	size_t kbest;
} gdl_phase_em_pl_param;

gdl_phase_em_pl_param * gdl_phase_em_pl_param_alloc (const gdl_view * v, const gdl_mask * m, const gdl_rng * rng, double pmt, double phcrm, size_t psize, size_t kbest);
void gdl_phase_em_pl_param_free (gdl_phase_em_pl_param * P);

typedef struct
{
    const char *name;
    size_t     size;
    int  (*alloc)   (void * state, const gdl_phase_em_pl_param * P);
    int  (*free)    (void * state);
    int  (*init)    (void * state, const gdl_gligation_type * T);
    size_t (*psize)  (void * state);
    int  (*iterate) (void * state, size_t i);
    int  (*ligation)  (void * state);
    double (*loglikelihood) (void * state);
    double (*residual_abs) (void * state);
    double (*residual_sq) (void * state);
    void * (*result) (void * state);
    int (*fread)   (FILE * stream, void * vstate);
    int (*fwrite)  (FILE * stream, const void * state);
} gdl_phase_em_pl_workspace_type;

typedef struct
{
	const gdl_phase_em_pl_workspace_type * type;
	gdl_phase_em_pl_param * param;
	void  *state;
} gdl_phase_em_pl_workspace;

gdl_phase_em_pl_workspace * gdl_phase_em_pl_workspace_alloc (const gdl_phase_em_pl_workspace_type * T, gdl_phase_em_pl_param * P);
void gdl_phase_em_pl_workspace_free (gdl_phase_em_pl_workspace * w);

int gdl_phase_em_pl_workspace_init (gdl_phase_em_pl_workspace * w, const gdl_gligation_type * T);
size_t gdl_phase_em_pl_workspace_psize (gdl_phase_em_pl_workspace * w);
int gdl_phase_em_pl_workspace_iterate (gdl_phase_em_pl_workspace * w, size_t i);
int gdl_phase_em_pl_workspace_ligation (gdl_phase_em_pl_workspace * w);

double gdl_phase_em_pl_workspace_loglikelihood (const gdl_phase_em_pl_workspace * w);
double gdl_phase_em_pl_workspace_residual_abs (const gdl_phase_em_pl_workspace * w);
double gdl_phase_em_pl_workspace_residual_sq (const gdl_phase_em_pl_workspace * w);

void * gdl_phase_em_pl_workspace_result (const gdl_phase_em_pl_workspace * w);

int gdl_phase_em_pl_workspace_fread (FILE * stream, gdl_phase_em_pl_workspace * w);
int gdl_phase_em_pl_workspace_fwrite (FILE * stream, const gdl_phase_em_pl_workspace * w);

GDL_VAR const gdl_phase_em_pl_workspace_type * gdl_phase_em_pl_hview;
//GDL_VAR const gdl_phase_em_pl_workspace_type * gdl_phase_em_pl_hmap;

 __END_DECLS

#endif
