/*  
 *  plot/extra.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */


#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_plot.h>

gdl_hashtable *
gdl_plot_parse_extra (const gdl_string * option)
{
	if (option)
	{
		size_t i, j, n;
		gdl_string * arg, * val; 
		gdl_hashtable * extra;
		
		extra = gdl_hashtable_alloc (gdl_string_interface, 0);
		
		arg = val = NULL;
		
		n = strlen (option);
		
		for (j = i = 0; i < n; i++)
		{
			if (isspace(option[i]))
			{
				if (option[j] == '-' && arg==0)
				{
					j++;
					arg = gdl_string_alloc (i-j);
					strncpy (arg, &option[j], i-j);
					for (; i < n && isspace (option[i]); i++);
					j = i--;
				}
				else if (arg)
				{
					val = gdl_string_alloc (i-j);
					strncpy (val, &option[j], i-j);
					gdl_hashtable_add (extra, arg, val, 1);
					for (; i < n && isspace (option[i]);i++);
					j = i--;
					gdl_string_free (arg);
					arg=NULL;
				}
				else
				{
					gdl_hashtable_free (extra);
					return NULL;	
				}
			}
		}
		// maybe the last one
		if (j < i && arg)
		{
			val = gdl_string_alloc (i-j);
			strncpy (val, &option[j], i-j);
			gdl_hashtable_add (extra, arg, val, 1);
		}
		return extra;
	}	
	return NULL;
}
