/*  
 *  plot/gdl_plot.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#ifndef __GDL_PLOT_H__
#define __GDL_PLOT_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_graphics.h>

__BEGIN_DECLS

typedef struct _gdl_plot_parameters gdl_plot_parameters;

typedef struct
{
	gdl_string * name;
	size_t     size;
	void   (*free) (void * p);
	void * (*copy) (const void * p); 
	int    (*fprintf) (FILE * stream, const void * p);
	void * (*fscanf)  (FILE * stream);
} gdl_plot_parameter_type;

typedef struct
{
	const gdl_plot_parameter_type * type;
	size_t   size;
	void  ** data;
} gdl_plot_parameter;

gdl_plot_parameter * gdl_plot_parameter_alloc (const gdl_plot_parameter_type * T, size_t size);
void gdl_plot_parameter_set (gdl_plot_parameter * p, size_t i, void * x);
void gdl_plot_parameter_set_copy (gdl_plot_parameter * p, size_t i, const void * x);
const void * gdl_plot_parameter_get (const gdl_plot_parameter * p, size_t i);
size_t gdl_plot_parameter_size (const gdl_plot_parameter * p);

gdl_plot_parameters * gdl_plot_parameters_alloc (void);
void gdl_plot_parameters_free (gdl_plot_parameters * params);
gdl_plot_parameter  * gdl_plot_parameters_get (const gdl_plot_parameters * par, const gdl_string * name);
int gdl_plot_parameters_set (gdl_plot_parameters * par, const gdl_string * name, gdl_plot_parameter * param);
int gdl_plot_parameters_fprintf (FILE * stream, const gdl_plot_parameters * par);
gdl_plot_parameters * gdl_plot_parameters_fscanf (FILE * stream);

typedef struct
{
	gdl_string * name;
	size_t size;
	int (*alloc) (void * plot, gdl_plot_parameters * params, const void * data, double * width, double * height);
	int (*free)  (void * plot);
	int (*draw)  (void * plot, const gdl_plot_parameters * params, gdl_graphics2D * graphics);
	int (*extra) (const gdl_string * extra, gdl_plot_parameters * par);
} gdl_plot_type;

typedef struct _gdl_plot gdl_plot;

gdl_plot * gdl_plot_alloc (const gdl_plot_type * type, const void * data, gdl_plot_parameters * par);
void gdl_plot_free (gdl_plot * plot);
int gdl_plot_draw (gdl_plot * plot, const gdl_string * file, gdl_graphics_device device);

typedef struct _gdl_plot_type_registry gdl_plot_type_registry;

const gdl_plot_type_registry * gdl_plot_type_registry_get (void);
const gdl_plot_type * gdl_plot_type_registry_search (const gdl_plot_type_registry * r, const gdl_string * name);

gdl_hashtable * gdl_plot_parse_extra (const gdl_string * option);

GDL_VAR const gdl_plot_parameter_type * gdl_plot_parameter_double;
GDL_VAR const gdl_plot_parameter_type * gdl_plot_parameter_int;
GDL_VAR const gdl_plot_parameter_type * gdl_plot_parameter_string;
GDL_VAR const gdl_plot_parameter_type * gdl_plot_parameter_rgb;
GDL_VAR const gdl_plot_parameter_type * gdl_plot_parameter_font;
GDL_VAR const gdl_plot_parameter_type * gdl_plot_parameter_extra;

__END_DECLS

#endif
