/*  
 *  plot/plot.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_graphics.h>
#include <gdl/gdl_plot.h>

static const double GDL_PLOT_MARGIN = 10;

struct _gdl_plot
{
	const gdl_plot_type * type;
	void                * plot;
	gdl_graphics2D      * graphics;
	const gdl_plot_parameters * par;
	double width;
	double height;
};

gdl_plot *
gdl_plot_alloc (const gdl_plot_type * T, const void * data, gdl_plot_parameters * par)
{
	gdl_plot_parameter * param;
	gdl_plot * p;
	
	p = GDL_MALLOC (gdl_plot, 1);
	
	p->type = T;
	
	p->par  = par;
	
	param = gdl_plot_parameters_get (par, "plot-margins");
	if (!param)
	{
		param = gdl_plot_parameter_alloc (gdl_plot_parameter_double, 2);
		gdl_plot_parameter_set_copy (param, 0, &GDL_PLOT_MARGIN);
		gdl_plot_parameter_set_copy (param, 1, &GDL_PLOT_MARGIN);
		gdl_plot_parameters_set (par, "plot-margins", param);
	}
	
	p->plot = gdl_malloc (T->size);
	
	(T->alloc)(p->plot, par, data, &(p->width), &(p->height));
	
	return p;
}

void
gdl_plot_free (gdl_plot * plot)
{
	if (plot)
	{
		(plot->type->free)(plot->plot);
		GDL_FREE (plot->plot);
		GDL_FREE (plot);
	}	
}

int
gdl_plot_draw (gdl_plot * plot, const gdl_string * file, gdl_graphics_device device)
{
	gdl_graphics2D * graphic;
	gdl_affine_transform * translation;
	gdl_plot_parameter * param;
	double * x, * y;
	
	param = gdl_plot_parameters_get (plot->par, "plot-margins");
	
	x = (double *) gdl_plot_parameter_get (param, 0);
	y = (double *) gdl_plot_parameter_get (param, 1);
	
	translation = gdl_affine_transform_translation (*x, *y);
	
	//gdl_graphics2D_set_transform (graphic, translation);
	
	graphic = gdl_graphics2D_open (file, plot->width+*x, plot->height+*y, device);
	
	(plot->type->draw)(plot->plot, plot->par, graphic);
	
	gdl_graphics2D_close (graphic, file);
	
	return GDL_SUCCESS;
}
