/*  
 *  plot/registry.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_plot.h>
#include <gdl/gdl_pstruct_result.h>
#include <gdl/gdl_hstruct_result.h>
#include <gdl/gdl_gpca_result.h>
#include <gdl/gdl_mosaic_result.h>

struct _gdl_plot_type_registry
{
	gdl_hashtable * table;	
};

static gdl_plot_type_registry _singleton =
{
	NULL	
};

static int
gdl_plot_type_registry_add (gdl_plot_type_registry * r, const gdl_string * name, const gdl_plot_type * type)
{
	gdl_hashtable_add (r->table, name, type, 0);
}

const gdl_plot_type_registry *
gdl_plot_type_registry_get (void)
{
	if (_singleton.table==NULL)
	{
		_singleton.table = gdl_hashtable_alloc (gdl_hash_default, 0);
		gdl_plot_type_registry_add (&_singleton, gdl_pstruct_result_plot->name, gdl_pstruct_result_plot);
		gdl_plot_type_registry_add (&_singleton, gdl_hstruct_result_plot->name, gdl_hstruct_result_plot);
		gdl_plot_type_registry_add (&_singleton, gdl_gpca_result_plot->name, gdl_gpca_result_plot);
		gdl_plot_type_registry_add (&_singleton, gdl_mosaic_result_plot->name, gdl_mosaic_result_plot);
	}
	return &_singleton;	
}

const gdl_plot_type *
gdl_plot_type_registry_search (const gdl_plot_type_registry * r, const gdl_string * name)
{
	return gdl_hashtable_lookup (r->table, name);	
}
