/*  
 *  pstruct/bic.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#include <math.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_pstruct.h>
#include <gdl/gdl_pstruct_result.h>
#include <gdl/gdl_pstruct_criterion.h>

static double
_gdl_pstruct_bic (const gdl_pstruct_result * r)
{
	double bic = -gdl_pstruct_result_loglikelihood (r);
	
	bic += 0.5*gdl_pstruct_result_parameter_size (r)
	       *log (gdl_pstruct_result_accession_size (r));
	
	return bic;
}

static const gdl_pstruct_criterion_type _bic =
{
	"gdl_pstruct_criterion_BIC",
	&_gdl_pstruct_bic
};

const gdl_pstruct_criterion_type * gdl_pstruct_criterion_BIC = &_bic;
