/*  
 *  pstruct/gdl_pstruct_criterion.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_PSTRUCT_CRITERION_H__
#define __GDL_PSTRUCT_CRITERION_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_pstruct.h>
#include <gdl/gdl_pstruct_result.h>

__BEGIN_DECLS

typedef struct 
{
	gdl_string * name;
	double (*value)(const gdl_pstruct_result * r);
} gdl_pstruct_criterion_type;

typedef struct _gdl_pstruct_criterion gdl_pstruct_criterion;

gdl_pstruct_criterion * gdl_pstruct_criterion_alloc (const gdl_pstruct_result * r);
void gdl_pstruct_criterion_free (gdl_pstruct_criterion * c);

double gdl_pstruct_criterion_value (const gdl_pstruct_criterion * c, const gdl_pstruct_criterion_type * T);

GDL_VAR const gdl_pstruct_criterion_type * gdl_pstruct_criterion_AIC;
GDL_VAR const gdl_pstruct_criterion_type * gdl_pstruct_criterion_BIC;

__END_DECLS

#endif
