/*  
 *  pstruct/gdl_pstruct_result.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_PSTRUCT_RESULT_H__
#define __GDL_PSTRUCT_RESULT_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_gblock.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_glabels.h>
#include <gdl/gdl_odb.h>
#include <gdl/gdl_plot.h>
#include <gdl/gdl_pstruct.h>

__BEGIN_DECLS

typedef struct
{
	const gdl_pstruct_workspace_type * type;
    size_t k;
  	size_t n;
  	size_t p;
  	size_t l;
  	size_t tna;
  	size_t * na;
  	gdl_hnblock  * f;
  	gdl_block    * q;
  	double       * pi;
  	double loglikelihood;
  	double residual;
  	double tw_residual;
  	gdl_glabels  * labels;
} gdl_pstruct_result;

gdl_pstruct_result * gdl_pstruct_result_alloc (const gdl_pstruct_workspace * work);
void gdl_pstruct_result_free (gdl_pstruct_result * r);

const gdl_glabels * gdl_pstruct_result_labels (const gdl_pstruct_result * r);

double gdl_pstruct_result_loglikelihood (const gdl_pstruct_result * r);
size_t gdl_pstruct_result_population_size (const gdl_pstruct_result * r);
size_t gdl_pstruct_result_accession_size (const gdl_pstruct_result * r);
size_t gdl_pstruct_result_locus_size (const gdl_pstruct_result * r);
size_t gdl_pstruct_result_parameter_size (const gdl_pstruct_result * r);
double gdl_pstruct_result_population_divergence (const gdl_pstruct_result * r, size_t pop1, size_t pop2);
double gdl_pstruct_result_get_population_q (const gdl_pstruct_result * r, size_t pop);
double gdl_pstruct_result_get_accession_q (const gdl_pstruct_result * r, size_t pop, size_t indiv);
double gdl_pstruct_result_get_locus_f (const gdl_pstruct_result * r, size_t pop, size_t loc, size_t allele);
size_t gdl_pstruct_result_get_locus_f_size (const gdl_pstruct_result * r, size_t loc);
size_t gdl_pstruct_result_get_accession_q_max_index (const gdl_pstruct_result * r, size_t i);
size_t * gdl_pstruct_result_qsort (const gdl_pstruct_result * r);

double gdl_pstruct_result_search_accession_q (const gdl_pstruct_result * r, size_t pop, const gdl_accession * accession);
double gdl_pstruct_result_search_locus_f (const gdl_pstruct_result * r, size_t pop, const gdl_locus * locus, const gdl_allele * allele);

gdl_pstruct_workspace * gdl_pstruct_result_gupdate (const gdl_pstruct_result * r, gdl_gview_wrapper * gw, gdl_rng * rng);
gdl_pstruct_workspace * gdl_pstruct_result_hupdate (const gdl_pstruct_result * r, gdl_hview * h, gdl_rng * rng);

gdl_pstruct_result * gdl_pstruct_result_fread (FILE * stream);
int gdl_pstruct_result_fwrite (FILE * stream, const gdl_pstruct_result * r);

int gdl_pstruct_result_fprintf (FILE * stream, const gdl_pstruct_result * r);

gdl_pstruct_result * gdl_pstruct_result_structure_read (FILE * stream, const gdl_gview * data);

GDL_VAR const gdl_odriver   * gdl_pstruct_result_driver;
GDL_VAR const gdl_plot_type * gdl_pstruct_result_plot;

__END_DECLS

#endif /* GDL_PSTRUCT_H */
