/* randist/gdl_randist.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 James Theiler, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDL_RANDIST_H__
#define __GDL_RANDIST_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_rng.h>

__BEGIN_DECLS

unsigned int gdl_ran_bernoulli (const gdl_rng * r, double p);
double gdl_ran_bernoulli_pdf (const unsigned int k, double p);

double gdl_ran_beta (const gdl_rng * r, const double a, const double b);
double gdl_ran_beta_pdf (const double x, const double a, const double b);

unsigned int gdl_ran_binomial (const gdl_rng * r, double p, unsigned int n);
unsigned int gdl_ran_binomial_tpe (const gdl_rng * r, double pp, unsigned int n);
double gdl_ran_binomial_pdf (const unsigned int k, const double p, const unsigned int n);

double gdl_ran_exponential (const gdl_rng * r, const double mu);
double gdl_ran_exponential_pdf (const double x, const double mu);

double gdl_ran_exppow (const gdl_rng * r, const double a, const double b);
double gdl_ran_exppow_pdf (const double x, const double a, const double b);

double gdl_ran_cauchy (const gdl_rng * r, const double a);
double gdl_ran_cauchy_pdf (const double x, const double a);

double gdl_ran_chisq (const gdl_rng * r, const double nu);
double gdl_ran_chisq_pdf (const double x, const double nu);

void gdl_ran_dirichlet (const gdl_rng * r, const size_t K, const double alpha[], double theta[]);
double gdl_ran_dirichlet_pdf (const size_t K, const double alpha[], const double theta[]);
double gdl_ran_dirichlet_lnpdf (const size_t K, const double alpha[], const double theta[]);

double gdl_ran_erlang (const gdl_rng * r, const double a, const double n);
double gdl_ran_erlang_pdf (const double x, const double a, const double n);

double gdl_ran_fdist (const gdl_rng * r, const double nu1, const double nu2);
double gdl_ran_fdist_pdf (const double x, const double nu1, const double nu2);

double gdl_ran_flat (const gdl_rng * r, const double a, const double b);
double gdl_ran_flat_pdf (double x, const double a, const double b);

double gdl_ran_gamma (const gdl_rng * r, const double a, const double b);
double gdl_ran_gamma_int (const gdl_rng * r, const unsigned int a);
double gdl_ran_gamma_pdf (const double x, const double a, const double b);

double gdl_ran_gaussian (const gdl_rng * r, const double sigma);
double gdl_ran_gaussian_ratio_method (const gdl_rng * r, const double sigma);
double gdl_ran_gaussian_pdf (const double x, const double sigma);
double gdl_ran_gaussian_quantile (const double p, const double sigma);

double gdl_ran_ugaussian (const gdl_rng * r);
double gdl_ran_ugaussian_ratio_method (const gdl_rng * r);
double gdl_ran_ugaussian_pdf (const double x);
double gdl_ran_ugaussian_quantile (const double p);

double gdl_ran_gaussian_tail (const gdl_rng * r, const double a, const double sigma);
double gdl_ran_gaussian_tail_pdf (const double x, const double a, const double sigma);

double gdl_ran_ugaussian_tail (const gdl_rng * r, const double a);
double gdl_ran_ugaussian_tail_pdf (const double x, const double a);

void gdl_ran_bivariate_gaussian (const gdl_rng * r, double sigma_x, double sigma_y, double rho, double *x, double *y);
double gdl_ran_bivariate_gaussian_pdf (const double x, const double y, const double sigma_x, const double sigma_y, const double rho);

double gdl_ran_landau (const gdl_rng * r);
double gdl_ran_landau_pdf (const double x);

unsigned int gdl_ran_geometric (const gdl_rng * r, const double p);
double gdl_ran_geometric_pdf (const unsigned int k, const double p);

unsigned int gdl_ran_hypergeometric (const gdl_rng * r, unsigned int n1, unsigned int n2, unsigned int t);
double gdl_ran_hypergeometric_pdf (const unsigned int k, const unsigned int n1, const unsigned int n2, unsigned int t);

double gdl_ran_gumbel1 (const gdl_rng * r, const double a, const double b);
double gdl_ran_gumbel1_pdf (const double x, const double a, const double b);

double gdl_ran_gumbel2 (const gdl_rng * r, const double a, const double b);
double gdl_ran_gumbel2_pdf (const double x, const double a, const double b);

double gdl_ran_logistic (const gdl_rng * r, const double a);
double gdl_ran_logistic_pdf (const double x, const double a);

double gdl_ran_lognormal (const gdl_rng * r, const double zeta, const double sigma);
double gdl_ran_lognormal_pdf (const double x, const double zeta, const double sigma);

unsigned int gdl_ran_logarithmic (const gdl_rng * r, const double p);
double gdl_ran_logarithmic_pdf (const unsigned int k, const double p);

void gdl_ran_multinomial (const gdl_rng * r, const size_t K,
                          const unsigned int N, const double p[],
                          unsigned int n[] );
double gdl_ran_multinomial_pdf (const size_t K,
                                const double p[], const unsigned int n[] );
double gdl_ran_multinomial_lnpdf (const size_t K,
                           const double p[], const unsigned int n[] );


unsigned int gdl_ran_negative_binomial (const gdl_rng * r, double p, double n);
double gdl_ran_negative_binomial_pdf (const unsigned int k, const double p, double n);

unsigned int gdl_ran_pascal (const gdl_rng * r, double p, unsigned int n);
double gdl_ran_pascal_pdf (const unsigned int k, const double p, unsigned int n);

double gdl_ran_pareto (const gdl_rng * r, double a, const double b);
double gdl_ran_pareto_pdf (const double x, const double a, const double b);

unsigned int gdl_ran_poisson (const gdl_rng * r, double mu);
void gdl_ran_poisson_array (const gdl_rng * r, size_t n, unsigned int array[],
                            double mu);
double gdl_ran_poisson_pdf (const unsigned int k, const double mu);

double gdl_ran_rayleigh (const gdl_rng * r, const double sigma);
double gdl_ran_rayleigh_pdf (const double x, const double sigma);

double gdl_ran_rayleigh_tail (const gdl_rng * r, const double a, const double sigma);
double gdl_ran_rayleigh_tail_pdf (const double x, const double a, const double sigma);

double gdl_ran_tdist (const gdl_rng * r, const double nu);
double gdl_ran_tdist_pdf (const double x, const double nu);

double gdl_ran_laplace (const gdl_rng * r, const double a);
double gdl_ran_laplace_pdf (const double x, const double a);

double gdl_ran_levy (const gdl_rng * r, const double c, const double alpha);
double gdl_ran_levy_skew (const gdl_rng * r, const double c, const double alpha, const double beta);

double gdl_ran_weibull (const gdl_rng * r, const double a, const double b);
double gdl_ran_weibull_pdf (const double x, const double a, const double b);

void gdl_ran_dir_2d (const gdl_rng * r, double * x, double * y);
void gdl_ran_dir_2d_trig_method (const gdl_rng * r, double * x, double * y);
void gdl_ran_dir_3d (const gdl_rng * r, double * x, double * y, double * z);
void gdl_ran_dir_nd (const gdl_rng * r, size_t n, double * x);

void gdl_ran_shuffle (const gdl_rng * r, void * base, size_t nmembm, size_t size);
int gdl_ran_choose (const gdl_rng * r, void * dest, size_t k, void * src, size_t n, size_t size) ;
void gdl_ran_sample (const gdl_rng * r, void * dest, size_t k, void * src, size_t n, size_t size) ;


typedef struct {                /* struct for Walker algorithm */
    size_t K;
    size_t *A;
    double *F;
} gdl_ran_discrete_t;

gdl_ran_discrete_t * gdl_ran_discrete_preproc (size_t K, const double *P);
void gdl_ran_discrete_free(gdl_ran_discrete_t *g);
size_t gdl_ran_discrete (const gdl_rng *r, const gdl_ran_discrete_t *g);
double gdl_ran_discrete_pdf (size_t k, const gdl_ran_discrete_t *g);


__END_DECLS

#endif /* __GDL_RANDIST_H__ */
