/*  
 *  result/gdl_result.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:41 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_RESULT_H__

#define __GDL_RESULT_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_odb.h>

__BEGIN_DECLS

typedef struct
{
	gdl_string  * data_file;
	gdl_string  * command;
	void        * object;
	const gdl_odriver * driver;
} gdl_result;

gdl_result * gdl_result_alloc (const gdl_string * data_file, const gdl_string * command, void * object, const gdl_odriver * driver);
void gdl_result_free (gdl_result * r);
gdl_string * gdl_result_data_file (gdl_result * r);
gdl_string *  gdl_result_command (gdl_result * r);
void * gdl_result_object (gdl_result * r);
const gdl_odriver * gdl_result_odriver (gdl_result * r);

GDL_VAR const gdl_odriver * gdl_result_driver;

__END_DECLS

#endif //__GDL_RESULT_H__

