/*  
 *  rho/forward.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:04 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <float.h>
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_randist.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_allele_block.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_rho.h>

void
gdl_rho_hmm_forward (gdl_rho * hmm, size_t K, size_t N)
{
	size_t j;
	double pr;
	
	pr = gdl_rho_hmm_forward_init (hmm, K, N);
	for (j = 1; j < hmm->data->L; j++)
	{
		gdl_rho_hmm_forward_induc (hmm, K, N, j, &pr);
	}
}

double
gdl_rho_hmm_forward_init (gdl_rho * hmm, size_t K, size_t N)
{
	size_t k;
	double x, y;
	
	hmm->util->norm[0] = 0.;
	for(k = 0; k < K; k++)
	{
		hmm->util->alpha[0][k] = gdl_rho_hmm_obs_proba (hmm, k, K, N, 0)/K;
		hmm->util->norm[0]     += hmm->util->alpha[0][k];
	}
	for(k = 0; k < K; k++)
	{
		hmm->util->alpha[0][k] /= hmm->util->norm[0];
	}	
	hmm->util->log = log(hmm->util->norm[0]);
	
	return hmm->util->norm[0];
}

void
gdl_rho_hmm_forward_induc (gdl_rho * hmm, size_t K, size_t N, size_t l, double * pr)
{
	size_t k, kk;
	double x, t, u, v, w, s;
	
	t = gdl_rho_hmm_norec_proba (hmm, K, l-1, hmm->data->D[l-1]);
	
	s = *pr;
	
	hmm->util->norm[l] = 0.;
	
	for (k = 0; k < K; k++)
	{
		x = hmm->util->alpha[l-1][k];
		x *= t;
		x += (1.0-t)*s/K;
		u = gdl_rho_hmm_obs_proba (hmm, k, K, N, l);
		x *= u;
		hmm->util->alpha[l][k] = x;
		hmm->util->norm[l] += hmm->util->alpha[l][k];
	}
	for (k = 0; k < K; k++)
	{
		hmm->util->alpha[l][k] /= hmm->util->norm[l];
	}
	hmm->util->log += log(hmm->util->norm[l]);
	
	*pr = hmm->util->norm[l];
}
