/*  
 *  rho/util.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:04 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <float.h>
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_allele_block.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_rho.h>

gdl_rho_util *
gdl_rho_util_alloc (const size_t N, const size_t L)
{
	gdl_rho_util * u;
	
	u = GDL_CALLOC (gdl_rho_util, 1);
	
	u->N = N;
	u->L = L;
	u->alpha = GDL_MATRIX_ALLOC (double, L, N);
	u->norm  = GDL_MALLOC (double, L);
	
	return u;
}

void
gdl_rho_util_free (gdl_rho_util * u)
{
	if (u)
	{
		GDL_MATRIX_FREE (u->alpha, u->L);
		GDL_FREE (u->norm);
		GDL_FREE (u);
	}
}
