/* rng/types.c
 * 
 * Copyright (C) 2001 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_rng.h>

#define N 100

const gdl_rng_type * gdl_rng_generator_types[N];

#define ADD(t) {if (i==N) abort(); gdl_rng_generator_types[i] = (t); i++; };

const gdl_rng_type **
gdl_rng_types_setup (void)
{
  int i = 0;

  ADD(gdl_rng_borosh13);
  ADD(gdl_rng_cmrg);
  ADD(gdl_rng_coveyou);
  ADD(gdl_rng_fishman18);
  ADD(gdl_rng_fishman20);
  ADD(gdl_rng_fishman2x);
  ADD(gdl_rng_gfsr4);
  ADD(gdl_rng_knuthran);
  ADD(gdl_rng_knuthran2);
  ADD(gdl_rng_lecuyer21);
  ADD(gdl_rng_minstd);
  ADD(gdl_rng_mrg);
  ADD(gdl_rng_mt19937);
  ADD(gdl_rng_mt19937_1999);
  ADD(gdl_rng_mt19937_1998);
  ADD(gdl_rng_r250);
  ADD(gdl_rng_ran0);
  ADD(gdl_rng_ran1);
  ADD(gdl_rng_ran2);
  ADD(gdl_rng_ran3);
  ADD(gdl_rng_rand);
  ADD(gdl_rng_rand48);
  ADD(gdl_rng_random128_bsd);
  ADD(gdl_rng_random128_glibc2);
  ADD(gdl_rng_random128_libc5);
  ADD(gdl_rng_random256_bsd);
  ADD(gdl_rng_random256_glibc2);
  ADD(gdl_rng_random256_libc5);
  ADD(gdl_rng_random32_bsd);
  ADD(gdl_rng_random32_glibc2);
  ADD(gdl_rng_random32_libc5);
  ADD(gdl_rng_random64_bsd);
  ADD(gdl_rng_random64_glibc2);
  ADD(gdl_rng_random64_libc5);
  ADD(gdl_rng_random8_bsd);
  ADD(gdl_rng_random8_glibc2);
  ADD(gdl_rng_random8_libc5);
  ADD(gdl_rng_random_bsd);
  ADD(gdl_rng_random_glibc2);
  ADD(gdl_rng_random_libc5);
  ADD(gdl_rng_randu);
  ADD(gdl_rng_ranf);
  ADD(gdl_rng_ranlux);
  ADD(gdl_rng_ranlux389);
  ADD(gdl_rng_ranlxd1);
  ADD(gdl_rng_ranlxd2);
  ADD(gdl_rng_ranlxs0);
  ADD(gdl_rng_ranlxs1);
  ADD(gdl_rng_ranlxs2);
  ADD(gdl_rng_ranmar);
  ADD(gdl_rng_slatec);
  ADD(gdl_rng_taus);
  ADD(gdl_rng_taus2);
  ADD(gdl_rng_taus113);
  ADD(gdl_rng_transputer);
  ADD(gdl_rng_tt800);
  ADD(gdl_rng_uni);
  ADD(gdl_rng_uni32);
  ADD(gdl_rng_vax);
  ADD(gdl_rng_waterman14);
  ADD(gdl_rng_zuf);
  ADD(0);

  return gdl_rng_generator_types;
}

