/* roots/gdl_roots.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Reid Priedhorsky, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GDL_ROOTS_H__
#define __GDL_ROOTS_H__

#include <stdlib.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_types.h>
#include <gdl/gdl_math.h>

__BEGIN_DECLS

typedef struct
  {
    const char *name;
    size_t size;
    int (*set) (void *state, gdl_function * f, double * root, double x_lower, double x_upper);
    int (*iterate) (void *state, gdl_function * f, double * root, double * x_lower, double * x_upper);
  }
gdl_root_fsolver_type;

typedef struct
  {
    const gdl_root_fsolver_type * type;
    gdl_function * function ;
    double root ;
    double x_lower;
    double x_upper;
    void *state;
  }
gdl_root_fsolver;

typedef struct
  {
    const char *name;
    size_t size;
    int (*set) (void *state, gdl_function_fdf * f, double * root);
    int (*iterate) (void *state, gdl_function_fdf * f, double * root);
  }
gdl_root_fdfsolver_type;

typedef struct
  {
    const gdl_root_fdfsolver_type * type;
    gdl_function_fdf * fdf ;
    double root ;
    void *state;
  }
gdl_root_fdfsolver;

gdl_root_fsolver *
gdl_root_fsolver_alloc (const gdl_root_fsolver_type * T);
void gdl_root_fsolver_free (gdl_root_fsolver * s);

int gdl_root_fsolver_set (gdl_root_fsolver * s,
                          gdl_function * f, 
                          double x_lower, double x_upper);

int gdl_root_fsolver_iterate (gdl_root_fsolver * s);

const char * gdl_root_fsolver_name (const gdl_root_fsolver * s);
double gdl_root_fsolver_root (const gdl_root_fsolver * s);
double gdl_root_fsolver_x_lower (const gdl_root_fsolver * s);
double gdl_root_fsolver_x_upper (const gdl_root_fsolver * s);


gdl_root_fdfsolver *
gdl_root_fdfsolver_alloc (const gdl_root_fdfsolver_type * T);

int
gdl_root_fdfsolver_set (gdl_root_fdfsolver * s, 
                         gdl_function_fdf * fdf, double root);

int
gdl_root_fdfsolver_iterate (gdl_root_fdfsolver * s);

void
gdl_root_fdfsolver_free (gdl_root_fdfsolver * s);

const char * gdl_root_fdfsolver_name (const gdl_root_fdfsolver * s);
double gdl_root_fdfsolver_root (const gdl_root_fdfsolver * s);

int
gdl_root_test_interval (double x_lower, double x_upper, double epsabs, double epsrel);

int
gdl_root_test_residual (double f, double epsabs);

int
gdl_root_test_delta (double x1, double x0, double epsabs, double epsrel);

GDL_VAR const gdl_root_fsolver_type  * gdl_root_fsolver_bisection;
GDL_VAR const gdl_root_fsolver_type  * gdl_root_fsolver_brent;
GDL_VAR const gdl_root_fsolver_type  * gdl_root_fsolver_falsepos;
GDL_VAR const gdl_root_fdfsolver_type  * gdl_root_fdfsolver_newton;
GDL_VAR const gdl_root_fdfsolver_type  * gdl_root_fdfsolver_secant;
GDL_VAR const gdl_root_fdfsolver_type  * gdl_root_fdfsolver_steffenson;

__END_DECLS

#endif /* __GDL_ROOTS_H__ */
