/*  
 *  seq/gdl_seq.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:41 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_SEQ_H__
#define __GDL_SEQ_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_hash.h>

__BEGIN_DECLS

typedef struct
{
	size_t idx;
	gdl_string * id;
	gdl_string * seq;
	void * extra;
} gdl_seq;

gdl_seq * gdl_seq_alloc (const gdl_string * id, const size_t idx);
void gdl_seq_free (gdl_seq * s);

gdl_string * gdl_seq_extract_string (const gdl_seq * seq, const size_t from, const size_t to);
void gdl_seq_reverse (gdl_seq * seq);
gdl_string * gdl_seq_reverse_str (gdl_string * str);
gdl_string * gdl_seq_dna2aa_str (gdl_string * str, const unsigned char strand, const size_t phase);

typedef struct
{
	size_t size;
	gdl_seq       ** seqs;
	gdl_hashtable * _id2seq;
} gdl_seqdb;

gdl_seqdb * gdl_seqdb_alloc (const size_t size);
void gdl_seqdb_free (gdl_seqdb * db);
int gdl_seqdb_refactor_seqids (gdl_seqdb * db, gdl_hashtable * refactor);

int gdl_seqdb_id2seq_create (gdl_seqdb * db);
gdl_seq * gdl_seqdb_id2seq_lookup (gdl_seqdb * db, const gdl_string * id);
int gdl_seqdb_id2seq_clean (gdl_seqdb * db);

gdl_boolean GDL_IUPAC_DNA_CODE (const char base);
gdl_boolean GDL_DNA_CODE_AMBIGUOUS (const char base);
gdl_boolean GDL_DNA_CODE_GAP (const char base);
char GDL_DNA_COMPLEMENT (const char base);
char GDL_DNA_TO_AA (gdl_string * codon);

__END_DECLS

#endif /* __GDL_SEQ_H__ */
