/*  
 *  seq/gdl_seq_io.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:41 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_SEQ_READER_H__
#define __GDL_SEQ_READER_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_seq.h>

__BEGIN_DECLS

typedef struct _gdl_seq_io gdl_seq_io;

typedef struct 
{
	gdl_string * name;
	gdl_string * acronym;
	int (*read)(gdl_seq_io * r);
	int (*write)(FILE * stream, const gdl_seq_io * w, const gdl_seqdb * db);
	int (*write_str)(FILE * stream, const gdl_seq_io * w, const gdl_string * str);
} gdl_seq_io_type;

struct _gdl_seq_io
{
	const gdl_seq_io_type * type;
	gdl_seqdb  * db;
	gdl_string * filename;
	gdl_string * error;
	FILE       * stream;	
};

gdl_seq_io * gdl_seq_io_alloc (const gdl_seq_io_type * type);
void gdl_seq_io_free (gdl_seq_io * io);
// Reader
int gdl_seq_io_open (gdl_seq_io * io, const gdl_string * filename);
int gdl_seq_io_parse (gdl_seq_io * io);
gdl_seqdb * gdl_seq_io_close (gdl_seq_io * io);
// Writer
int gdl_seq_io_dump (FILE * stream, const gdl_seq_io * io, const gdl_seqdb  * db);
int gdl_seq_io_string_dump (FILE * stream, const gdl_seq_io * io, const gdl_string * str);
// Util
int gdl_seq_io_error (gdl_seq_io * io, char * format, ...);

GDL_VAR const gdl_seq_io_type * gdl_seq_io_fasta;

const gdl_seq_io_type * gdl_seq_io_type_get (const gdl_string * name);

__END_DECLS

#endif /* __GDL_SEQ_READER_H__ */
