/*
 *  snp/clone.c 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_cnv_data.h>

gdl_cnv_clone *
gdl_cnv_clone_alloc (const gdl_string * name, long start, long end)
{
	gdl_cnv_clone * c;
	
	c = GDL_CALLOC (gdl_cnv_clone, 1);
	
	c->name  = gdl_string_clone (name);
	c->start = start;
	c->end   = end;
	
	return c;
}

void
gdl_cnv_clone_free (gdl_cnv_clone * c)
{
	if (c)
	{
		GDL_FREE (c->name);
		GDL_FREE (c);	
	}	
}

gdl_cnv_clone *
gdl_cnv_clone_fread (FILE * stream)
{
	if (stream)
	{
		int status;
		gdl_string * name;
		long start, end;
		gdl_cnv_clone * c;
		
		name = gdl_string_fread (stream);
		GDL_FREAD_STATUS (name!=0, 1);
		status = fread (&start, sizeof(long), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&end, sizeof(long), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		
		c = gdl_cnv_clone_alloc (name, start, end);
		
		gdl_string_free (name);
		
		return c;
	}
	return 0;	
}

int
gdl_cnv_clone_fwrite (FILE * stream, const gdl_cnv_clone * c)
{
	if (stream && c)
	{
		int status;
		
		status = gdl_string_fwrite (stream, c->name);
		GDL_FWRITE_STATUS (status, GDL_SUCCESS);
		status = fwrite (&c->start, sizeof(long), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (&c->end, sizeof(long), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		
		return GDL_SUCCESS;
	}
	return GDL_EINVAL;
}

