/*
 *  snp/format.c 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_matrix_uchar.h>
#include <gdl/gdl_snp_data.h>

gdl_snp_data_format *
gdl_snp_data_format_alloc (const size_t P)
{
	gdl_snp_data_format * f;
	
	f = GDL_MALLOC (gdl_snp_data_format, 1);
	
	f->P = P;
	f->na_char = (char)P+1;
	f->label   = gdl_false;
	f->haplo   = gdl_false;
	
	return f;	
}

void
gdl_snp_data_format_free (gdl_snp_data_format * f)
{
	if (f)
	{
		GDL_FREE (f);
	}	
}
