/*
 *  snp/fprintf.c 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_matrix_uchar.h>
#include <gdl/gdl_snp_data.h>

int
gdl_snp_data_fprintf (FILE * stream, const gdl_snp_data * v)
{
	if (stream && v)
	{
		size_t i, j;
		
		for (i = 0; i < v->N; i++)
		{
			for(j = 0; j < v->L; j++)
			{
				printf (" %c", gdl_snp_data_get (v, i, j));
			}
			printf ("\n");
		}
		
		return GDL_SUCCESS;
	}
	
	return GDL_EINVAL;
}
