/*
 *  snp/gdl_snp_data.h 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_SNP_DATA_H__
#define __GDL_SNP_DATA_H__

#include <stdio.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>

__BEGIN_DECLS

typedef struct
{
	double * afreq;
	double * gfreq;
	size_t missing;
} gdl_snp_stats;

gdl_snp_stats * gdl_snp_stats_alloc (void);
void gdl_snp_stats_free (gdl_snp_stats * s);
void gdl_snp_stats_reset (gdl_snp_stats * s);

typedef struct 
{
	size_t P;
	char na_char;
	gdl_boolean label;
	gdl_boolean haplo; 
} gdl_snp_data_format;

gdl_snp_data_format * gdl_snp_data_format_alloc (const size_t P);
void gdl_snp_data_format_free (gdl_snp_data_format * f);

typedef struct
{
	gdl_string * name;
} gdl_snp_data_type;

GDL_VAR const gdl_snp_data_type * gdl_snp_data_genotype;
GDL_VAR const gdl_snp_data_type * gdl_snp_data_haplotype;

typedef struct
{
	size_t N;
	size_t L;
	size_t P;
	const gdl_snp_data_type * T;
	unsigned char * data;
} gdl_snp_data;

gdl_snp_data * gdl_snp_data_alloc (const gdl_snp_data_type * T, const size_t N, const size_t L, const size_t P);
void gdl_snp_data_free (gdl_snp_data * v);

gdl_boolean gdl_snp_data_is_missing (const gdl_snp_data * v, size_t i, size_t j);
int gdl_snp_data_get (const gdl_snp_data * v, size_t i, size_t j);
int gdl_snp_data_hget (const gdl_snp_data * v, size_t i, size_t j, size_t k);
void gdl_snp_data_set (const gdl_snp_data * v, size_t i, size_t j, unsigned char u);
void gdl_snp_data_hset (const gdl_snp_data * v, size_t i, size_t j, size_t k, unsigned char u);
void gdl_snp_data_snp_stats (const gdl_snp_data * v, size_t i, gdl_snp_stats * s);

gdl_snp_data * gdl_snp_data_fread (FILE * stream);
gdl_snp_data * gdl_snp_data_fscanf (FILE * stream, const gdl_snp_data_format * T);
int gdl_snp_data_fwrite (FILE * stream, const gdl_snp_data * v);
int gdl_snp_data_fprintf (FILE * stream, const gdl_snp_data * v);

__END_DECLS

#endif
