/*
 *  snp/gmap.c 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_snp_map.h>
#include <gdl/gdl_snp_data.h>
#include <gdl/gdl_snp_chromosome.h>

/**
 * Read the genetic map from HapMap rec rate file
 */
int
gdl_snp_chromosome_gmap (gdl_snp_chromosome * chrom, FILE * stream)
{
	const size_t M = chrom->chrom->size;
	size_t i,j,k,n;
	long position;
	double genetic, physic;
	gdl_string * tok, * line=0;
	gdl_snp ** snps = chrom->chrom->snps;
	
	// ignore header
	gdl_getline (&line, &n, stream);
	gdl_string_free (line);line=0;
	k=0;
	while(gdl_getline (&line, &n, stream)!=-1)
	{
		i=j=0;
		tok=gdl_string_next_token (line, n, &i, &j);
		position=atol(tok);
		gdl_string_free (tok);
		if (snps[k]->position!=position)
		{
			gdl_string_free (line);line=0;
			continue;
		}
//		for(;k<M && snps[k]->position!=position;k++)
//		{
//			snps[k]->rate=0;
//			if (k) snps[k]->distance=snps[k-1]->distance;
//		}
		// rate
		tok=gdl_string_next_token (line, n, &i, &j);
		gdl_string_free (tok);
		// distance
		tok=gdl_string_next_token (line, n, &i, &j);
		snps[k]->distance=(double)atof(tok);
		gdl_string_free (tok);
		gdl_string_free (line);line=0;
		if (k)
		{
			physic  = ((double)(snps[k]->position-snps[k-1]->position));
			genetic = snps[k]->distance-snps[k-1]->distance;
			snps[k-1]->rate = genetic/physic;
		}
		k++;
		if (k==M) break;
	}
	// should never happen !
	for(;k<M;k++)
	{
		snps[k]->rate=0;
		if (k) snps[k]->distance=snps[k-1]->distance;
	}
}
