/*
 *  snp/map.c 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_snp.h>
#include <gdl/gdl_snp_map.h>

gdl_snp_map *
gdl_snp_map_alloc (const size_t size)
{
	gdl_snp_map * c;
	
	c = GDL_MALLOC (gdl_snp_map, 1);
	
	c->size = size;
	c->snps = GDL_CALLOC (gdl_snp *, size);
	
	return c;
}

void
gdl_snp_map_free (gdl_snp_map * c)
{
	if (c)
	{
		size_t i;
		for (i = 0; i < c->size; i++)
		{
			gdl_snp_free (c->snps[i]);
		}
		GDL_FREE (c->snps);
		GDL_FREE (c);
	}
}

size_t
gdl_snp_map_size (const gdl_snp_map * c)
{
	return c->size;
}

gdl_snp *
gdl_snp_map_get (const gdl_snp_map * c, size_t i)
{
	return c->snps[i];
}	

void
gdl_snp_map_set (const gdl_snp_map * c, size_t i, gdl_snp * snp)
{
	c->snps[i]=snp;
}

void
gdl_snp_map_merge (gdl_snp_map * c1, const gdl_snp_map * c2)
{
	size_t i=0, j=0, n=0;
	gdl_snp ** tmp;
	
	for (; i < c1->size && j < c2->size;)
	{
		if (c1->snps[i]->position > c2->snps[j]->position)
		{
			for(;c2->snps[j]->position < c1->snps[i]->position && j < c2->size; j++);
		}
		else if (c2->snps[j]->position > c1->snps[i]->position)
		{
			for(;c1->snps[i]->position < c2->snps[j]->position && i < c1->size; i++);
		}
		else if (c1->snps[i]->position==c2->snps[j]->position)
		{
			i++;
			j++;
			n++;	
		}
	}
	n   = c1->size+c2->size-n;
	tmp = GDL_MALLOC (gdl_snp *, n);
	for (n = 0; i < c1->size && j < c2->size;)
	{
		if (c1->snps[i]->position > c2->snps[j]->position)
		{
			for(;c2->snps[j]->position < c1->snps[i]->position && j < c2->size; j++, n++)
			{
				tmp[n] = gdl_snp_clone (c2->snps[j]);
				// alloc new...
				// nidx[n][p] = j+1;
			}
		}
		else if (c2->snps[j]->position > c1->snps[i]->position)
		{
			for(;c1->snps[i]->position < c2->snps[j]->position && i < c1->size; i++, n++)
			{
				tmp[n]  = c1->snps[i];
				// nidx[n] = oidx[i];
			}
		}
		else if (c1->snps[i]->position==c2->snps[j]->position)
		{
			tmp[n] = c1->snps[i];
			// nidx[n] = oidx[i];
			// nidx[n][p] = j+1;
			i++;
			j++;
			n++;	
		}
	}
	GDL_FREE (c1->snps);
	c1->size  = n;
	c1->snps = tmp;
}
