/*
 *  snp/stats.c 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_matrix_uchar.h>
#include <gdl/gdl_snp_data.h>

gdl_snp_stats *
gdl_snp_stats_alloc (void)
{
	gdl_snp_stats * s;
	
	s = GDL_CALLOC (gdl_snp_stats, 1);
	
	s->afreq = GDL_CALLOC (double, 2);
	s->gfreq = GDL_CALLOC (double, 3);
	
	return s;	
}

void
gdl_snp_stats_free (gdl_snp_stats * s)
{
	if (s)
	{
		GDL_FREE (s->afreq);
		GDL_FREE (s->gfreq);
		GDL_FREE (s);
	}
}

void
gdl_snp_stats_reset (gdl_snp_stats * s)
{
	s->missing=0;
	s->afreq[0]=s->afreq[1]=0;
	s->gfreq[0]=s->gfreq[1]=s->gfreq[2]=0;
}

void
gdl_snp_data_snp_stats (const gdl_snp_data * v, size_t j, gdl_snp_stats * stats)
{
	size_t i;
	
	gdl_snp_stats_reset (stats);
	
	if (v->P==2)
	{
		for (i = 0; i < v->N; i++)
		{
			switch (gdl_snp_data_get (v, i, j))
			{
				case 0:
					stats->afreq[0]+=2;
					stats->gfreq[0]+=1;
					break;
				case 1:
					stats->afreq[0]+=1;
					stats->afreq[1]+=1;
					stats->gfreq[1]+=1;
					break;
				case 2:
					stats->afreq[1]+=2;
					stats->gfreq[2]+=1;
					break;
				default:
					stats->missing++;
					break;
			}
		}
		for (i = 0; i < 3; i++)
		{
			if (i < 2) stats->afreq[i] /= 2*(v->N-stats->missing);
			stats->gfreq[i] /= v->N-stats->missing;
		}
	}
	else
	{
		for (i = 0; i < v->N; i++)
		{
			switch (gdl_snp_data_get (v, i, j))
			{
				case 0:
					stats->afreq[0]+=1;
					break;
				case 1:
					stats->afreq[1]+=1;
					break;
				default:
					stats->missing++;
					break;
			}
		}
		for (i = 0; i < 2; i++)
		{
			stats->gfreq[i] = stats->afreq[i] /= 2*(v->N-stats->missing);
		}
	}
}
