/* sort/gdl_heapsort.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Thomas Walter, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDL_HEAPSORT_H__
#define __GDL_HEAPSORT_H__

#include <gdl/gdl_common.h>

__BEGIN_DECLS

typedef int (*gdl_comparison_fn_t) (const void *, const void *);

void gdl_heapsort (void * array, size_t count, size_t size, gdl_comparison_fn_t compare);
int gdl_heapsort_index (size_t * p, const void * array, size_t count, size_t size, gdl_comparison_fn_t compare);

__END_DECLS

#endif /* __GDL_HEAPSORT_H__ */
