/* sort/gdl_sort_vector_double.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Thomas Walter, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDL_SORT_VECTOR_DOUBLE_H__
#define __GDL_SORT_VECTOR_DOUBLE_H__

#include <stdlib.h>
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_permutation.h>
#include <gdl/gdl_vector_double.h>

__BEGIN_DECLS

void gdl_sort_vector (gdl_vector * v);
int gdl_sort_vector_index (gdl_permutation * p, const gdl_vector * v);

int gdl_sort_vector_smallest (double * dest, const size_t k, const gdl_vector * v);
int gdl_sort_vector_largest (double * dest, const size_t k, const gdl_vector * v);

int gdl_sort_vector_smallest_index (size_t * p, const size_t k, const gdl_vector * v);
int gdl_sort_vector_largest_index (size_t * p, const size_t k, const gdl_vector * v);

__END_DECLS

#endif /* __GDL_SORT_VECTOR_DOUBLE_H__ */
