/* sort/test_source.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Thomas Walter, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

void TYPE (test_sort_vector) (size_t N, size_t stride);
void FUNCTION (my, initialize) (TYPE (gdl_vector) * v);
void FUNCTION (my, randomize) (TYPE (gdl_vector) * v);
int FUNCTION (my, check) (TYPE (gdl_vector) * data, TYPE (gdl_vector) * orig);
int FUNCTION (my, pcheck) (gdl_permutation * p, TYPE (gdl_vector) * data, TYPE (gdl_vector) * orig);
int FUNCTION (my, scheck) (BASE * x, size_t k, TYPE (gdl_vector) * data);
int FUNCTION (my, lcheck) (BASE * x, size_t k, TYPE (gdl_vector) * data);
int FUNCTION (my, sicheck) (size_t * p, size_t k, gdl_permutation * perm,
                            TYPE (gdl_vector) * data);
int FUNCTION (my, licheck) (size_t * p, size_t k, gdl_permutation * perm,
                            TYPE (gdl_vector) * data);

void
TYPE (test_sort_vector) (size_t N, size_t stride)
{
  int status;
  size_t  k = N/2;

  TYPE (gdl_block) * b1 = FUNCTION (gdl_block, calloc) (N * stride);
  TYPE (gdl_block) * b2 = FUNCTION (gdl_block, calloc) (N * stride);
  TYPE (gdl_block) * b3 = FUNCTION (gdl_block, calloc) (N * stride);

  TYPE (gdl_vector) * orig = FUNCTION (gdl_vector, alloc_from_block) (b1, 0, N, stride);
  TYPE (gdl_vector) * data = FUNCTION (gdl_vector, alloc_from_block) (b2, 0, N, stride);
  TYPE (gdl_vector) * data2 = FUNCTION (gdl_vector, alloc_from_block) (b3, 0, N, stride);

  BASE * small = malloc(k * sizeof(BASE));
  BASE * large = malloc(k * sizeof(BASE));
  size_t * index = malloc(k * sizeof(size_t));

  gdl_permutation *p = gdl_permutation_alloc (N);

  FUNCTION (my, initialize) (orig);

  /* Already sorted */
  FUNCTION (gdl_vector, memcpy) (data, orig);

  status = FUNCTION (gdl_sort_vector, index) (p, data);
  status |= FUNCTION (my, pcheck) (p, data, orig);
  gdl_test (status, "indexing " NAME (gdl_vector) ", n = %u, stride = %u, ordered", N, stride);

  TYPE (gdl_sort_vector) (data);
  status = FUNCTION (my, check) (data, orig);
  gdl_test (status, "sorting, " NAME (gdl_vector) ", n = %u, stride = %u, ordered", N, stride);

  FUNCTION (gdl_sort_vector, smallest) (small, k, data);
  status = FUNCTION (my, scheck) (small, k, orig);
  gdl_test (status, "smallest, " NAME (gdl_vector) ", n = %u, stride = %u, ordered", N, stride);

  FUNCTION (gdl_sort_vector, largest) (large, k, data);
  status = FUNCTION (my, lcheck) (large, k, orig);
  gdl_test (status, "largest, " NAME (gdl_vector) ", n = %u, stride = %u, ordered", N, stride);

  FUNCTION (gdl_sort_vector, smallest_index) (index, k, data);
  status = FUNCTION (my, sicheck) (index, k, p, data);
  gdl_test (status, "smallest index, " NAME (gdl_vector) ", n = %u, stride = %u, ordered", N, stride);

  FUNCTION (gdl_sort_vector, largest_index) (index, k, data);
  status = FUNCTION (my, licheck) (index, k, p, data);
  gdl_test (status, "largest index, " NAME (gdl_vector) ", n = %u, stride = %u, ordered", N, stride);

  /* Reverse the data */

  FUNCTION (gdl_vector, memcpy) (data, orig);
  FUNCTION (gdl_vector, reverse) (data);

  status = FUNCTION (gdl_sort_vector, index) (p, data);
  status |= FUNCTION (my, pcheck) (p, data, orig);
  gdl_test (status, "indexing " NAME (gdl_vector) ", n = %u, stride = %u, reversed", N, stride);

  TYPE (gdl_sort_vector) (data);
  status = FUNCTION (my, check) (data, orig);
  gdl_test (status, "sorting, " NAME (gdl_vector) ", n = %u, stride = %u, reversed", N, stride);

  FUNCTION (gdl_vector, memcpy) (data, orig);
  FUNCTION (gdl_vector, reverse) (data);

  FUNCTION (gdl_sort_vector, smallest) (small, k, data);
  status = FUNCTION (my, scheck) (small, k, orig);
  gdl_test (status, "smallest, " NAME (gdl_vector) ", n = %u, stride = %u, reversed", N, stride);

  FUNCTION (gdl_sort_vector, largest) (large, k, data);
  status = FUNCTION (my, lcheck) (large, k, orig);
  gdl_test (status, "largest, " NAME (gdl_vector) ", n = %u, stride = %u, reversed", N, stride);

  FUNCTION (gdl_sort_vector, smallest_index) (index, k, data);
  status = FUNCTION (my, sicheck) (index, k, p, data);
  gdl_test (status, "smallest index, " NAME (gdl_vector) ", n = %u, stride = %u, reversed", N, stride);

  FUNCTION (gdl_sort_vector, largest_index) (index, k, data);
  status = FUNCTION (my, licheck) (index, k, p, data);
  gdl_test (status, "largest index, " NAME (gdl_vector) ", n = %u, stride = %u, reversed", N, stride);

  /* Perform some shuffling */

  FUNCTION (gdl_vector, memcpy) (data, orig);
  FUNCTION (my, randomize) (data);
  FUNCTION (gdl_vector, memcpy) (data2, data);

  status = FUNCTION (gdl_sort_vector, index) (p, data);
  status |= FUNCTION (my, pcheck) (p, data, orig);
  gdl_test (status, "indexing " NAME (gdl_vector) ", n = %u, stride = %u, randomized", N, stride);

  TYPE (gdl_sort_vector) (data);
  status = FUNCTION (my, check) (data, orig);
  gdl_test (status, "sorting, " NAME (gdl_vector) ", n = %u, stride = %u, randomized", N, stride);

  FUNCTION (gdl_vector, memcpy) (data, data2);

  FUNCTION (gdl_sort_vector, smallest) (small, k, data);
  status = FUNCTION (my, scheck) (small, k, orig);
  gdl_test (status, "smallest, " NAME (gdl_vector) ", n = %u, stride = %u, randomized", N, stride);

  FUNCTION (gdl_sort_vector, largest) (large, k, data);
  status = FUNCTION (my, lcheck) (large, k, orig);
  gdl_test (status, "largest, " NAME (gdl_vector) ", n = %u, stride = %u, randomized", N, stride);

  FUNCTION (gdl_sort_vector, smallest_index) (index, k, data);
  status = FUNCTION (my, sicheck) (index, k, p, data);
  gdl_test (status, "smallest index, " NAME (gdl_vector) ", n = %u, stride = %u, randomized", N, stride);

  FUNCTION (gdl_sort_vector, largest_index) (index, k, data);
  status = FUNCTION (my, licheck) (index, k, p, data);
  gdl_test (status, "largest index, " NAME (gdl_vector) ", n = %u, stride = %u, randomized", N, stride);

  FUNCTION (gdl_vector, free) (orig);
  FUNCTION (gdl_vector, free) (data);
  FUNCTION (gdl_vector, free) (data2);
  FUNCTION (gdl_block, free) (b1);
  FUNCTION (gdl_block, free) (b2);
  FUNCTION (gdl_block, free) (b3);
  gdl_permutation_free (p);
  free (small);
  free (large);
}


void
FUNCTION (my, initialize) (TYPE (gdl_vector) * v)
{
  size_t i;
  ATOMIC k = 0, kk;

  /* Must be sorted initially */

  for (i = 0; i < v->size; i++)
    {
      kk = k;
      k++;
      if (k < kk)               /* prevent overflow */
        k = kk;
      FUNCTION (gdl_vector, set) (v, i, k);
    }
}

void
FUNCTION (my, randomize) (TYPE (gdl_vector) * v)
{
  size_t i;

  for (i = 0; i < v->size; i++)
    {
      size_t j = urand (v->size);
      FUNCTION (gdl_vector, swap_elements) (v, i, j);
    }
}

int
FUNCTION (my, check) (TYPE (gdl_vector) * data, TYPE (gdl_vector) * orig)
{
  size_t i;

  for (i = 0; i < data->size; i++)
    {
      if (FUNCTION (gdl_vector, get) (data, i) != FUNCTION (gdl_vector, get) (orig, i))
        {
          return GDL_FAILURE;
        }
    }

  return GDL_SUCCESS;
}

int
FUNCTION (my, pcheck) (gdl_permutation * p, TYPE (gdl_vector) * data, TYPE (gdl_vector) * orig)
{
  size_t i;

  for (i = 0; i < p->size; i++)
    {
      if (FUNCTION (gdl_vector, get) (data, p->data[i]) != FUNCTION (gdl_vector, get) (orig, i))
        {
          return GDL_FAILURE;
        }
    }

  return GDL_SUCCESS;
}

int
FUNCTION (my, scheck) (BASE * x, size_t k, TYPE (gdl_vector) * data)
{
  size_t i;

  for (i = 0; i < k; i++)
    {
      if (x[i] != FUNCTION (gdl_vector, get) (data, i))
        {
          return GDL_FAILURE;
        }
    }

  return GDL_SUCCESS;
}



int
FUNCTION (my, lcheck) (BASE * x, size_t k, TYPE (gdl_vector) * data)
{
  size_t i;

  for (i = 0; i < k; i++)
    {
      if (x[i] != FUNCTION (gdl_vector, get) (data, data->size - i - 1))
        {
          return GDL_FAILURE;
        }
    }

  return GDL_SUCCESS;
}


int
FUNCTION (my, sicheck) (size_t * p1, size_t k, gdl_permutation * p,
                        TYPE (gdl_vector) * data)
{
  size_t i;

  for (i = 0; i < k; i++)
    {
      if (FUNCTION(gdl_vector,get)(data,p1[i]) 
          != FUNCTION(gdl_vector,get)(data, p->data[i]))
        {
          return GDL_FAILURE;
        }
    }

  return GDL_SUCCESS;
}

int
FUNCTION (my, licheck) (size_t * p1, size_t k, gdl_permutation * p,
                        TYPE (gdl_vector) * data)
{
  size_t i;

  for (i = 0; i < k; i++)
    {
      if (FUNCTION(gdl_vector,get)(data,p1[i]) 
          != FUNCTION(gdl_vector,get)(data, p->data[p->size - i - 1]))
        {
          return GDL_FAILURE;
        }
    }

  return GDL_SUCCESS;
}



