/* specfunc/gdl_sf_result.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Author:  G. Jungman */

#ifndef __GDL_SF_RESULT_H__
#define __GDL_SF_RESULT_H__

__BEGIN_DECLS

struct gdl_sf_result_struct {
  double val;
  double err;
};
typedef struct gdl_sf_result_struct gdl_sf_result;

#define GDL_SF_RESULT_SET(r,v,e) do { (r)->val=(v); (r)->err=(e); } while(0)


struct gdl_sf_result_e10_struct {
  double val;
  double err;
  int    e10;
};
typedef struct gdl_sf_result_e10_struct gdl_sf_result_e10;

int gdl_sf_result_smash_e(const gdl_sf_result_e10 * re, gdl_sf_result * r);

__END_DECLS

#endif /* __GDL_SF_RESULT_H__ */
