/* statistics/test.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Jim Davies, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#include <gdl/gdl_test.h>
#include <gdl/gdl_sort.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_statistics.h>

int test_nist (void);

/* Test program for mean.c.  JimDavies 7.96 */

#define BASE_LONG_DOUBLE
#include "templates_on.h"
#include "test_float_source.c"
#include "templates_off.h"
#undef  BASE_LONG_DOUBLE

#define BASE_DOUBLE
#include "templates_on.h"
#include "test_float_source.c"
#include "templates_off.h"
#undef  BASE_DOUBLE

#define BASE_FLOAT
#include "templates_on.h"
#include "test_float_source.c"
#include "templates_off.h"
#undef  BASE_FLOAT

#define BASE_ULONG
#include "templates_on.h"
#include "test_int_source.c"
#include "templates_off.h"
#undef  BASE_ULONG

#define BASE_LONG
#include "templates_on.h"
#include "test_int_source.c"
#include "templates_off.h"
#undef  BASE_LONG

#define BASE_UINT
#include "templates_on.h"
#include "test_int_source.c"
#include "templates_off.h"
#undef  BASE_UINT

#define BASE_INT
#include "templates_on.h"
#include "test_int_source.c"
#include "templates_off.h"
#undef  BASE_INT

#define BASE_USHORT
#include "templates_on.h"
#include "test_int_source.c"
#include "templates_off.h"
#undef  BASE_USHORT

#define BASE_SHORT
#include "templates_on.h"
#include "test_int_source.c"
#include "templates_off.h"
#undef  BASE_SHORT

#define BASE_UCHAR
#include "templates_on.h"
#include "test_int_source.c"
#include "templates_off.h"
#undef  BASE_UCHAR

#define BASE_CHAR
#include "templates_on.h"
#include "test_int_source.c"
#include "templates_off.h"
#undef  BASE_CHAR

int
test_medpolish(void)
{
//	size_t i, j;
//	double t, r[5], c[3], z[15];
//	double ** x = GDL_MATRIX_ALLOC (double, 5, 3);
//	x[0][0] = 14;
//	x[0][1] = 15;
//	x[0][2] = 14;
//	x[1][0] = 7;
//	x[1][1] = 4;
//	x[1][2] = 7;
//	x[2][0] = 8;
//	x[2][1] = 2;
//	x[2][2] = 10;
//	x[3][0] = 15;
//	x[3][1] = 9;
//	x[3][2] = 10;
//	x[4][0] = 0;
//	x[4][1] = 2;
//	x[4][2] = 0;
//	printf ("MEDPOLISH STATUS  = %d\n", gdl_stats_medpolish (x, 5, 3, 0.01, 10, &t, r, c, z));
//	for(i = 0; i < 5; i++)
//	{
//		for(j = 0; j < 3; j++)
//			printf (" %g", x[i][j]);
//		printf ("\n");	
//	}
//	printf ("t = %g\n", t);
//	printf ("r = %g %g %g %g %g\n", r[0], r[1], r[2], r[3], r[4]);
//	printf ("c = %g %g %g\n", c[0], c[1], c[2]);
	
	double ** x = GDL_MATRIX_ALLOC (double, 11, 78);
	double t, r[11], c[78], * z = GDL_MALLOC (double, 11*78);
	size_t i,ii,j,jj,n; 
	gdl_string * line = 0, * tok;
	FILE * stream = gdl_fileopen("data.txt","r");
	
	ii=0;
	while (gdl_getline (&line, &n, stream) != -1)
	{
		i = j = 0;
		for(jj = 0; jj < 78; jj++)
		{
			tok = gdl_string_next_token (line, n, &i, &j);
			x[ii][jj] = (double)atof(tok);
			gdl_string_free (tok);
			printf(" %e", x[ii][jj]);
		}
		printf("\n");
		gdl_string_free (line);line=0;
		ii++;
	}
	gdl_fileclose ("data.txt", stream);
	printf ("MEDPOLISH STATUS  = %d\n", gdl_stats_medpolish (x, 11, 78, 0.01, 10, &t, r, c, z));
	printf ("t = %g\n", t);
	printf ("r = ");
	for(i = 0; i < 11; i++) printf(" %g", r[i]);
	printf ("\n");
	printf ("c = ");
	for(i = 0; i < 78; i++) printf(" %g", c[i]);
	printf ("\n");
}

int
main (void)
{
  size_t s1, s2;

//  for (s1 = 1; s1 < 4 ; s1++) 
//    {
//      s2 = (s1 < 3) ? 1 : (s1 - 1) ;
//
//      test_func (s1,s2);
//      test_float_func (s1,s2);
//      test_long_double_func (s1,s2);
//       test_ulong_func (s1,s2);
//      test_long_func (s1,s2);
//      test_uint_func (s1,s2);
//      test_int_func (s1,s2);
//      test_ushort_func (s1,s2);
//      test_short_func (s1,s2);
//      test_uchar_func (s1,s2);
//      test_char_func (s1,s2);
//    }
//
//  test_nist();
  
  test_medpolish();

  exit (gdl_test_summary ());
}

