/*  
 * 	string/gdl_string.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_STRING_H__
#define __GDL_STRING_H__

#include <string.h>
#include <gdl/gdl_common.h>

__BEGIN_DECLS

typedef char gdl_string;

gdl_string * gdl_string_alloc (size_t n);
gdl_string * gdl_string_realloc (gdl_string * str, size_t n);
void gdl_string_free (gdl_string * str);
gdl_string * gdl_string_clone (const gdl_string * string);
void gdl_string_clean (gdl_string * string);
gdl_string * gdl_string_fread (FILE * stream);
int gdl_string_fwrite (FILE * stream, const gdl_string * str);
size_t gdl_string_cat (gdl_string ** string, const int c);
size_t gdl_string_scat (gdl_string * string, const gdl_string * format, ...);
gdl_string * gdl_string_sprintf (const gdl_string * format, ...);
gdl_string * gdl_string_vsprintf (const gdl_string * format, va_list ap);
gdl_boolean gdl_string_is_space (const gdl_string * string);
size_t gdl_string_sep (const gdl_string * sep, const gdl_string * string);
size_t gdl_string_nsep (const gdl_string * sep, const gdl_string * string, size_t n);
size_t gdl_string_token (const gdl_string * sep, const gdl_string * string);
size_t gdl_string_ntoken (const gdl_string * sep, const gdl_string * string, size_t n);
size_t gdl_string_token_start (const gdl_string * sep, const gdl_string * string, gdl_string ** token);
void gdl_string_token_next (const gdl_string * sep, const gdl_string * string, gdl_string ** token, size_t * next);
size_t gdl_string_ntoken_start (const gdl_string * sep, const gdl_string * string, size_t n, gdl_string ** token);
void gdl_string_ntoken_next (const gdl_string * sep, const gdl_string * string, size_t n, gdl_string ** token, size_t * next);

gdl_string * gdl_string_next_token (const gdl_string * l, const size_t n, size_t * start, size_t * end);
gdl_string ** gdl_string_split (const gdl_string * str, const gdl_string * del, size_t * n);

gdl_string * gdl_string_escape (const gdl_string * str, const gdl_string * exception);
gdl_string * gdl_string_unescape (const gdl_string * str, int len, gdl_string * target);

gdl_string ** gdl_string_one_column_file (const gdl_string * filename, size_t * n);
 
GDL_VAR const gdl_data_interface * gdl_string_interface;

__END_DECLS

#endif /* __GDL_STRING_H__ */
