/*  
 * 	sys/gdl_malloc.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:48 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>

extern void *
gdl_malloc (const size_t num)
{
  void *new = malloc (num);
  if (!new)
    GDL_ERROR_VOID("Memory exhausted", GDL_ENOMEM);
  return new;
}

extern void *
gdl_realloc (void *p, const size_t num)
{
  void *new;

  if (!p)
    return gdl_malloc (num);
  new = realloc (p, num);
  if (!new)
    GDL_ERROR_VOID("Memory exhausted", GDL_ENOMEM);

  return new;
}

extern void *
gdl_calloc (const size_t num, const size_t size)
{
  void *new = gdl_malloc (num * size);
  bzero (new, num * size);
  return new;
}

extern void **
gdl_malloc2D (const size_t size1, const size_t size2, const size_t num1, const size_t num2)
{
	size_t i;
	void **new = (void **) gdl_malloc(num1*size1);
	for ( i = 0; i < num1; i++)
	{
		new[i] = gdl_calloc(num2, size2);
	}
	return new;
}

extern void *
gdl_array_grow (const size_t type, void * p, size_t * size, void * x)
{
	if (*size)
	{
		size_t n = *size+1;
		void * tmp = gdl_malloc(n * type);
		memcpy (tmp, p, (n-1) * type);
		free (p);
		p = tmp;
	}
	else
	{
		*size = 0;
		p = gdl_malloc(type);
	}
	memcpy (p + *size, x, type);
	(*size)++;
	
	return p;
}
