/*  
 *  sys/nint.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:48 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

void
FUNCTION (gdl_interface, free) (void * o)
{
	GDL_FREE (o);
}

void *
FUNCTION (gdl_interface, clone) (const void * o)
{
	ATOMIC * c = GDL_MALLOC (ATOMIC, 1);
	*c = *((ATOMIC *)o);
	return c;
}

int
FUNCTION (gdl_interface, compare) (const void * o1, const void * o2)
{
	if (o1 == NULL || o2 == NULL)
	{
		return -2;	
	}
	if (o1 == o2)
	{
		return 0;	
	}
	else if (*((ATOMIC *)o1) < *((ATOMIC *)o2))
	{
		return -1;
	}
	else if (*((ATOMIC *)o1) < *((ATOMIC *)o2))
	{
		return 1;	
	}

	return 0;	
}

void *
FUNCTION (gdl_interface, fread) (FILE * stream)
{
	if (stream)
	{
		ATOMIC * o = GDL_MALLOC (ATOMIC, 1);
		
		int status = fread (o, sizeof (ATOMIC), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		
		return o;
	}
	return NULL;
}

int
FUNCTION (gdl_interface, fwrite) (FILE * stream, const void * o)
{
	if (stream && o)
	{
		int status = fwrite (o, sizeof (ATOMIC), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		
		return GDL_SUCCESS;
	}
	
	return GDL_EINVAL;
}

static const gdl_data_interface TYPE (_gdl_interface) =
{
	&(FUNCTION (gdl_interface, free)),
	&(FUNCTION (gdl_interface, clone)),
	&(FUNCTION (gdl_interface, compare)),
	&(FUNCTION (gdl_interface, fread)),
	&(FUNCTION (gdl_interface, fwrite))
};

const gdl_data_interface * TYPE (gdl_interface) = &(TYPE (_gdl_interface));
