/* test/gdl_test.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman, Brian Gough
 * 
 * Modified by Jean-Baptiste Veyrieras, 2006.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDL_TEST_H__
#define __GDL_TEST_H__

#include <gdl/gdl_common.h>

__BEGIN_DECLS

void
  gdl_test (int status, const char *test_description, ...);

void
gdl_test_rel (double result, double expected, double relative_error,
              const char *test_description, ...) ;

void
gdl_test_abs (double result, double expected, double absolute_error,
              const char *test_description, ...) ;

void
gdl_test_factor (double result, double expected, double factor,
                 const char *test_description, ...) ;

void
gdl_test_int (int result, int expected, const char *test_description, ...) ;

void
gdl_test_str (const char * result, const char * expected, 
              const char *test_description, ...) ;

void
  gdl_test_verbose (int verbose) ;

int
  gdl_test_summary (void) ;


__END_DECLS

#endif /* __GDL_TEST_H__ */
