/*  
 * 	util/file.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_util.h>

extern void *
gdl_array_fread (size_t atomic, size_t num, FILE * stream)
{
	int status;
	void * v;
		
	v = gdl_malloc (atomic*num);
	status = fread (v, atomic, num, stream);
	GDL_FREAD_STATUS (status, num);
	
	return v;
}

extern int
gdl_array_fwrite (void * v, size_t atomic, size_t num, FILE * stream)
{
	int status = fwrite (v, atomic, num, stream);
	GDL_FWRITE_STATUS (status, num);
	return GDL_SUCCESS;
}
