/*  
 * 	view/fread.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_locus_type.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_gmap.h>
#include <gdl/gdl_hmap.h>
#include <gdl/gdl_view.h>

static gdl_boolean
_has_fread (FILE * stream)
{
	int status;
	gdl_boolean has;
	
	status = fread (&has, sizeof (gdl_boolean), 1, stream);
	GDL_FREAD_STATUS (status, 1);
	
	return has;
}

gdl_view *
gdl_view_fread (FILE * stream)
{
	if (stream)
	{
		int status;
		gdl_boolean has;
		gdl_view * v = gdl_view_alloc ();
		
		has = _has_fread (stream); // gdata
		if (has)
		{
			v->gdata = gdl_gview_fread (stream);
			GDL_FREAD_STATUS (v->gdata != NULL, 1);
			v->_ginit = gdl_false;
		}
		has = _has_fread (stream);
		if (has)
		{
			has = _has_fread (stream);
			
			if (has)
			{
				v->hdata_mask = gdl_mask_fread (stream);
				GDL_FREAD_STATUS (v->hdata_mask != NULL, 1);
			}
			
			v->hdata = gdl_hview_alloc (v->gdata, v->hdata_mask);
			
			status = gdl_hview_fread (stream, v->hdata);
			GDL_FREAD_STATUS (status, GDL_SUCCESS);
		}
		has = _has_fread (stream);
		
		if (has)
		{
			v->gmap = gdl_gmap_fread (stream);
			GDL_FREAD_STATUS (v->gmap != NULL, 1);
			
			has = _has_fread (stream);
		
			if (has)
			{
				has = _has_fread (stream);
				
				if (has)
				{
					v->hmap_mask = gdl_mask_fread (stream);
					GDL_FREAD_STATUS (v->hmap_mask != NULL, 1);
				}
				
				v->hmap = gdl_hmap_alloc (v->gdata, v->hmap_mask, v->gmap);
				
				status = gdl_hmap_fread (stream, v->hmap);
				GDL_FREAD_STATUS (status, GDL_SUCCESS);
			}
		}
		has = _has_fread (stream); // tdata
		if (has)
		{
			v->tdata = gdl_fview_fread (stream);
			GDL_FREAD_STATUS (v->tdata != NULL, 1);
			v->_tinit = gdl_false;
		}
		has = _has_fread (stream); // odata
		if (has)
		{
			v->odata = gdl_fview_fread (stream);
			GDL_FREAD_STATUS (v->odata != NULL, 1);
			v->_oinit = gdl_false;
		}
		has = _has_fread (stream); // locus_type
		if (has)
		{
			v->locus_type = gdl_locus_type_registry_fread (stream);
			GDL_FREAD_STATUS (v->locus_type != NULL, 1);
		}
				
		return v;
	}
	return NULL;	
}

static gdl_boolean
_has_fwrite (FILE * stream, void * data)
{
	int status;
	gdl_boolean has;
	
	has = (data!=NULL) ? gdl_true : gdl_false;
	status = fwrite (&has, sizeof (gdl_boolean), 1, stream);
	GDL_FWRITE_STATUS (status, 1);
	
	return has;
}

int
gdl_view_fwrite (FILE * stream, const gdl_view * v)
{
	if (stream == 0 || v == 0)
	{
		return GDL_EINVAL;
	}
	else
	{
		gdl_boolean has;
		int status;
		
		has = _has_fwrite (stream, v->gdata);
		if (has)
		{
			status = gdl_gview_fwrite (stream, v->gdata);
			GDL_FWRITE_STATUS (status, GDL_SUCCESS);
		}
		
		has = _has_fwrite (stream, v->hdata);
		
		if (has)
		{
			has = _has_fwrite (stream, v->hdata_mask);
			if (has)
			{
				status = gdl_mask_fwrite (stream, v->hdata_mask);
				GDL_FWRITE_STATUS (status, GDL_SUCCESS);
			}
			status = gdl_hview_fwrite (stream, v->hdata);
			GDL_FWRITE_STATUS (status, GDL_SUCCESS);
		}
			
		has = _has_fwrite (stream, v->gmap);
		
		if (has)
		{
			status = gdl_gmap_fwrite (stream, v->gmap);
			GDL_FWRITE_STATUS (status, GDL_SUCCESS);
			
			has = _has_fwrite (stream, v->hmap);
		
			if (has)
			{
				has = _has_fwrite (stream, v->hmap_mask);
				
				if (has)
				{
					status = gdl_mask_fwrite (stream, v->hmap_mask);
					GDL_FWRITE_STATUS (status, GDL_SUCCESS);
				}
				
				status = gdl_hmap_fwrite (stream, v->hmap);
				GDL_FWRITE_STATUS (status, GDL_SUCCESS);
			}
				
		}
		
		has = _has_fwrite (stream, v->tdata);
		if (has)
		{
			status = gdl_fview_fwrite (stream, v->tdata);
			GDL_FWRITE_STATUS (status, GDL_SUCCESS);
		}
		
		has = _has_fwrite (stream, v->odata);
		if (has)
		{
			status = gdl_fview_fwrite (stream, v->odata);
			GDL_FWRITE_STATUS (status, GDL_SUCCESS);
		}
		
		has = _has_fwrite (stream, v->locus_type);
		if (has)
		{
			status = gdl_locus_type_registry_fwrite (stream, v->locus_type);
			GDL_FWRITE_STATUS (status, GDL_SUCCESS);
		}
		
		return GDL_SUCCESS;
	}	
}

