/*  
 * 	view/gdl_view.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_VIEW_H__
#define __GDL_VIEW_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_locus_type.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_gmap.h>
#include <gdl/gdl_hmap.h>
#include <gdl/gdl_fview.h>
#include <gdl/gdl_fview_wrapper.h>

__BEGIN_DECLS

typedef struct
{
	gdl_boolean   _ginit;
	gdl_boolean   _tinit;
	gdl_boolean   _oinit;
	gdl_gview     * gdata;
	gdl_hview     * hdata;
	gdl_mask     * hdata_mask;
	gdl_gmap      * gmap;
	gdl_hmap      * hmap;
	gdl_mask     * hmap_mask;
	gdl_fview     * tdata;
	gdl_fview     * odata;
	gdl_locus_type_registry * locus_type;
} gdl_view;

gdl_view * gdl_view_alloc ();
void gdl_view_free (gdl_view * v);

gdl_view * gdl_view_fread (FILE * stream);
int gdl_view_fwrite (FILE * stream, const gdl_view * v);

int gdl_view_add_gview (gdl_view * v, const gdl_string * name, gdl_gview * g);
int gdl_view_add_tview (gdl_view * v, const gdl_string * name, gdl_fview * t);
int gdl_view_add_oview (gdl_view * v, const gdl_string * name, gdl_fview * o);
int gdl_view_add_locus_type (gdl_view * v, const gdl_locus_type_registry * r);

void gdl_view_set_gview (gdl_view * v, gdl_gview * g);
void gdl_view_set_hview (gdl_view * v, gdl_hview * h);
void gdl_view_set_gmap (gdl_view * v, gdl_gmap * g);
void gdl_view_set_hmap (gdl_view * v, gdl_hmap * h);

gdl_gview * gdl_view_get_gview (const gdl_view * v);
gdl_hview * gdl_view_get_hview (const gdl_view * v);
gdl_gmap  * gdl_view_get_gmap (const gdl_view * v);
gdl_hmap  * gdl_view_get_hmap (const gdl_view * v);
gdl_fview * gdl_view_get_tview (const gdl_view * v);
gdl_fview * gdl_view_get_oview (const gdl_view * v);
gdl_locus_type_registry * gdl_view_get_locus_type (const gdl_view * v);

gdl_gmap * gdl_view_extract_gmap (const gdl_view * v, const gdl_mask * m);
gdl_gmap * gdl_view_extract_hgmap (const gdl_view * v, const gdl_mask * m);
gdl_gmap * gdl_view_extract_gmap_clone (const gdl_view * v, const gdl_mask * m);
gdl_gmap * gdl_view_extract_hgmap_clone (const gdl_view * v, const gdl_mask * m);

size_t gdl_view_shared_accession (const gdl_gview * gview, gdl_mask ** gmaskptr, const gdl_fview * fview, gdl_mask ** fmaskptr);
size_t gdl_view_wrapper_shared_accession (const gdl_gview_wrapper * gview, gdl_mask ** gmaskptr, const gdl_fview_wrapper * fview, gdl_mask ** fmaskptr);
size_t gdl_view_generic_wrapper_shared_accession (const void * wrapper1, const gdl_entity_type * wtype1, gdl_mask ** mask1ptr, const void * wrapper2, const gdl_entity_type * wtype2, gdl_mask ** mask2ptr); 

__END_DECLS

#endif /* __GDL_VIEW_H__ */
