/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.utils;

import org.apache.commons.collections.Transformer;

public class RefSeqAccessionToChrNameConverter
implements Transformer {
    static RefSeqAccessionToChrNameConverter instance;

    private RefSeqAccessionToChrNameConverter() {
    }

    public static RefSeqAccessionToChrNameConverter getInstance() {
        if (instance == null) {
            instance = new RefSeqAccessionToChrNameConverter();
        }
        return instance;
    }

    public Object transform(Object arg0) {
        int chrNo;
        String refSeqAccession = (String)arg0;
        if (refSeqAccession.charAt(2) != '_') {
            throw new IllegalArgumentException(refSeqAccession + " does not look like a RefSeq accession");
        }
        int sepIndex = refSeqAccession.indexOf(".");
        if (sepIndex > 0) {
            refSeqAccession = refSeqAccession.substring(0, sepIndex);
        }
        if ((chrNo = Integer.parseInt(refSeqAccession.substring(3))) != 1807 && chrNo > 24) {
            throw new IllegalArgumentException("Chromosome number must be 24 or less");
        }
        String chr = String.valueOf(chrNo);
        if (chr.equals("23")) {
            chr = "X";
        }
        if (chr.equals("24")) {
            chr = "Y";
        }
        if (chr.equals("1807")) {
            chr = "MT";
        }
        return chr;
    }

    public static String getChromosomeName(String refSeqAccession) {
        return (String)RefSeqAccessionToChrNameConverter.getInstance().transform(refSeqAccession);
    }
}

